/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemAtualizaValoresEntradaEst;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="ATUALIZA_VAL_ENT_EST")
public class AtualizaValoresEntradaEst
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Date dataInicial;
    private Date dataFinal;
    private Usuario usuario;
    private String descricao;
    private List<ItemAtualizaValoresEntradaEst> itemAtualizaValoresEntradaEst = new ArrayList<ItemAtualizaValoresEntradaEst>();
    private Short implantacaoSaldos = 0;
    private Short comunicadoProducao = 0;
    private Short nfProprias = 0;
    private Short nfTerceiros = 0;
    private Short transferencias = 0;

    @Id
    @Column(nullable=false, name="ID_ATUALIZA_VAL_ENT_EST")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ATUALIZA_VAL_ENT_EST")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ATUALIZA_VAL_ENT_EST_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_ATUALIZA_VAL_ENT_EST_USUARIO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Column(name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="atualizaValoresEntradaEst")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ItemAtualizaValoresEntradaEst> getItemAtualizaValoresEntradaEst() {
        return this.itemAtualizaValoresEntradaEst;
    }

    public void setItemAtualizaValoresEntradaEst(List<ItemAtualizaValoresEntradaEst> itemAtualizaValoresEntradaEst) {
        this.itemAtualizaValoresEntradaEst = itemAtualizaValoresEntradaEst;
    }

    @Column(name="IMPLANTACAO_SALDOS")
    public Short getImplantacaoSaldos() {
        return this.implantacaoSaldos;
    }

    public void setImplantacaoSaldos(Short implantacaoSaldos) {
        this.implantacaoSaldos = implantacaoSaldos;
    }

    @Column(name="COMUNICADO_PRODUCAO")
    public Short getComunicadoProducao() {
        return this.comunicadoProducao;
    }

    public void setComunicadoProducao(Short comunicadoProducao) {
        this.comunicadoProducao = comunicadoProducao;
    }

    @Column(name="NF_PROPRIA")
    public Short getNfProprias() {
        return this.nfProprias;
    }

    public void setNfProprias(Short nfProprias) {
        this.nfProprias = nfProprias;
    }

    @Column(name="NF_TERCEIROS")
    public Short getNfTerceiros() {
        return this.nfTerceiros;
    }

    public void setNfTerceiros(Short nfTerceiros) {
        this.nfTerceiros = nfTerceiros;
    }

    @Column(name="TRANSFERENCIAS")
    public Short getTransferencias() {
        return this.transferencias;
    }

    public void setTransferencias(Short transferencias) {
        this.transferencias = transferencias;
    }
}

