/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AtualizacaoVTLocalTrabalho;
import com.touchcomp.basementor.model.vo.AtualizacaoVTSindicato;
import com.touchcomp.basementor.model.vo.CadastroBeneficioRefeicaoCesta;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ATUALIZACAO_VALORES_VT")
public class AtualizacaoValoresVT
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private String descricao;
    private Date dataAlteracao;
    private Short reprocessarManuais = 0;
    private List<AtualizacaoVTSindicato> sindicatos = new ArrayList<AtualizacaoVTSindicato>();
    private List<CadastroBeneficioRefeicaoCesta> beneficios;
    private List<AtualizacaoVTLocalTrabalho> localTrabalho = new ArrayList<AtualizacaoVTLocalTrabalho>();

    public AtualizacaoValoresVT() {
        this.beneficios = new ArrayList<CadastroBeneficioRefeicaoCesta>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_ATUALIZACAO_VALORES_VT")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN__ATUALIZACAO_VALORES_VT")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_AT_VALORES_VT_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ALTERACAO")
    public Date getDataAlteracao() {
        return this.dataAlteracao;
    }

    public void setDataAlteracao(Date dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    @Column(name="REPROCESSAR_MANUAIS")
    public Short getReprocessarManuais() {
        return this.reprocessarManuais;
    }

    public void setReprocessarManuais(Short reprocessarManuais) {
        this.reprocessarManuais = reprocessarManuais;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="atualizacaoVt", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<AtualizacaoVTSindicato> getSindicatos() {
        return this.sindicatos;
    }

    public void setSindicatos(List<AtualizacaoVTSindicato> sindicatos) {
        this.sindicatos = sindicatos;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getDescricao();
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="atualizacaoVt", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<CadastroBeneficioRefeicaoCesta> getBeneficios() {
        return this.beneficios;
    }

    public void setBeneficios(List<CadastroBeneficioRefeicaoCesta> beneficios) {
        this.beneficios = beneficios;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="atualizacaoVt", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<AtualizacaoVTLocalTrabalho> getLocalTrabalho() {
        return this.localTrabalho;
    }

    public void setLocalTrabalho(List<AtualizacaoVTLocalTrabalho> localTrabalho) {
        this.localTrabalho = localTrabalho;
    }
}

