/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BombaCombustivel;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.ItemAutConsumoAtivo;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="AUT_CONSUMO_ATIVO")
public class AutConsumoAtivo
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Date dataAutorizacao;
    private Long nrDocOrigem = 0L;
    private Double hodometro = 0.0;
    private Equipamento equipamento;
    private OrdemServico ordemServico;
    private BombaCombustivel bombaCombustivel;
    private Pessoa solicitante;
    private String observacao;
    private List<ItemAutConsumoAtivo> itemAutConsumoAtivo = new ArrayList<ItemAutConsumoAtivo>();

    @Id
    @Column(nullable=false, name="ID_AUT_CONSUMO_ATIVO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_AUT_CONSUMO_ATIVO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_AUT_CONSUMO_ATIVO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_AUTORIZACAO")
    public Date getDataAutorizacao() {
        return this.dataAutorizacao;
    }

    public void setDataAutorizacao(Date dataAutorizacao) {
        this.dataAutorizacao = dataAutorizacao;
    }

    @Column(name="NR_DOC_ORIGEM")
    public Long getNrDocOrigem() {
        return this.nrDocOrigem;
    }

    public void setNrDocOrigem(Long nrDocOrigem) {
        this.nrDocOrigem = nrDocOrigem;
    }

    @Column(name="HODOMETRO", precision=15, scale=6)
    public Double getHodometro() {
        return this.hodometro;
    }

    public void setHodometro(Double hodometro) {
        this.hodometro = hodometro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EQUIPAMENTO", foreignKey=@ForeignKey(name="FK_AUT_CONSUMO_ATIVO_EQUIP"))
    public Equipamento getEquipamento() {
        return this.equipamento;
    }

    public void setEquipamento(Equipamento equipamento) {
        this.equipamento = equipamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ORDEM_SERVICO", foreignKey=@ForeignKey(name="FK_AUT_CONSUMO_ATIVO_ORDEM_SERV"))
    public OrdemServico getOrdemServico() {
        return this.ordemServico;
    }

    public void setOrdemServico(OrdemServico ordemServico) {
        this.ordemServico = ordemServico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BOMBA_COMBUSTIVEL", foreignKey=@ForeignKey(name="FK_AUT_CONSUMO_ATIVO_BOMBA_COMB"))
    public BombaCombustivel getBombaCombustivel() {
        return this.bombaCombustivel;
    }

    public void setBombaCombustivel(BombaCombustivel bombaCombustivel) {
        this.bombaCombustivel = bombaCombustivel;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SOLICITANTE", foreignKey=@ForeignKey(name="FK_AUT_CONSUMO_ATIVO_SOLICIT"))
    public Pessoa getSolicitante() {
        return this.solicitante;
    }

    public void setSolicitante(Pessoa solicitante) {
        this.solicitante = solicitante;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @OneToMany(mappedBy="autConsumoAtivo", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<ItemAutConsumoAtivo> getItemAutConsumoAtivo() {
        return this.itemAutConsumoAtivo;
    }

    public void setItemAutConsumoAtivo(List<ItemAutConsumoAtivo> itemAutConsumoAtivo) {
        this.itemAutConsumoAtivo = itemAutConsumoAtivo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getEquipamento()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

