/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AutorizacaoRetiradaProduto;
import com.touchcomp.basementor.model.vo.BaixaAutorizacaoRetirada;
import com.touchcomp.basementor.model.vo.ConjuntoTransportador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TipoOperacaoAutorizacaoRetirada;
import com.touchcomp.basementor.model.vo.UnidadeFatTransporte;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="AUTORIZACAO_RETIRADA", uniqueConstraints={@UniqueConstraint(name="UNQ1_AUTORIZACAO_RETIRADA", columnNames={"NUMERO_AR"})})
public class AutorizacaoRetirada
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Long numeroAR = 0L;
    private Date dataAR;
    private TipoOperacaoAutorizacaoRetirada tipoOperacaoAR;
    private ConjuntoTransportador conjuntoTransportador;
    private UnidadeFatTransporte contratante;
    private UnidadeFatTransporte remetente;
    private UnidadeFatTransporte destinatario;
    private UnidadeFatTransporte consignatario;
    private List<AutorizacaoRetiradaProduto> produtos = new ArrayList<AutorizacaoRetiradaProduto>();
    private List<BaixaAutorizacaoRetirada> baixaAutorizacaoRetirada = new ArrayList<BaixaAutorizacaoRetirada>();
    private Pessoa solicitante;
    private Pessoa pessoaLocalRetirada;
    private Usuario usuario;
    private String observacao;

    @Id
    @Column(name="ID_AUTORIZACAO_RETIRADA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_AUTORIZACAO_RETIRADA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_AUTORIZACAO_RET_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="NUMERO_AR")
    public Long getNumeroAR() {
        return this.numeroAR;
    }

    public void setNumeroAR(Long numeroAR) {
        this.numeroAR = numeroAR;
    }

    @Column(name="DATA_AR")
    @Temporal(value=TemporalType.DATE)
    public Date getDataAR() {
        return this.dataAR;
    }

    public void setDataAR(Date dataAR) {
        this.dataAR = dataAR;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_OPERACA_AR", foreignKey=@ForeignKey(name="FK_AUTORIZACAO_RET_TP_OPER_AR"))
    public TipoOperacaoAutorizacaoRetirada getTipoOperacaoAR() {
        return this.tipoOperacaoAR;
    }

    public void setTipoOperacaoAR(TipoOperacaoAutorizacaoRetirada tipoOperacaoAR) {
        this.tipoOperacaoAR = tipoOperacaoAR;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONJUNTO_TRANPORTADOR", foreignKey=@ForeignKey(name="FK_AUTORIZACAO_RET_CONJ_TRANSP"))
    public ConjuntoTransportador getConjuntoTransportador() {
        return this.conjuntoTransportador;
    }

    public void setConjuntoTransportador(ConjuntoTransportador conjuntoTransportador) {
        this.conjuntoTransportador = conjuntoTransportador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTRATANTE", foreignKey=@ForeignKey(name="FK_AUTORIZACAO_RET_CONTRATANTE"))
    public UnidadeFatTransporte getContratante() {
        return this.contratante;
    }

    public void setContratante(UnidadeFatTransporte contratante) {
        this.contratante = contratante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REMETENTE", foreignKey=@ForeignKey(name="FK_AUTORIZACAO_RET_REMETENTE"))
    public UnidadeFatTransporte getRemetente() {
        return this.remetente;
    }

    public void setRemetente(UnidadeFatTransporte remetente) {
        this.remetente = remetente;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DESTINATARIO", foreignKey=@ForeignKey(name="FK_AUTORIZACAO_RET_DESTINATARIO"))
    public UnidadeFatTransporte getDestinatario() {
        return this.destinatario;
    }

    public void setDestinatario(UnidadeFatTransporte destinatario) {
        this.destinatario = destinatario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONSIGNATARIO", foreignKey=@ForeignKey(name="FK_AUTORIZACAO_RET_CONSIGNATARI"))
    public UnidadeFatTransporte getConsignatario() {
        return this.consignatario;
    }

    public void setConsignatario(UnidadeFatTransporte consignatario) {
        this.consignatario = consignatario;
    }

    @OneToMany(targetEntity=AutorizacaoRetiradaProduto.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="autorizacaoRetirada")
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.PERSIST})
    public List<AutorizacaoRetiradaProduto> getProdutos() {
        return this.produtos;
    }

    public void setProdutos(List<AutorizacaoRetiradaProduto> produtos) {
        this.produtos = produtos;
    }

    @OneToMany(mappedBy="autorizacaoRetirada", fetch=FetchType.LAZY, targetEntity=BaixaAutorizacaoRetirada.class)
    public List<BaixaAutorizacaoRetirada> getBaixaAutorizacaoRetirada() {
        return this.baixaAutorizacaoRetirada;
    }

    public void setBaixaAutorizacaoRetirada(List<BaixaAutorizacaoRetirada> baixaAutorizacaoRetirada) {
        this.baixaAutorizacaoRetirada = baixaAutorizacaoRetirada;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNumeroAR()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SOLICITANTE", foreignKey=@ForeignKey(name="FK_AUT_RETIRADA_SOLICITANTE"))
    public Pessoa getSolicitante() {
        return this.solicitante;
    }

    public void setSolicitante(Pessoa solicitante) {
        this.solicitante = solicitante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_AUT_RETIRADA_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_LOCAL_RETIRADA", foreignKey=@ForeignKey(name="FK_AUT_RETIRADA_PESS_LOCAL_RET"))
    public Pessoa getPessoaLocalRetirada() {
        return this.pessoaLocalRetirada;
    }

    public void setPessoaLocalRetirada(Pessoa pessoaLocalRetirada) {
        this.pessoaLocalRetirada = pessoaLocalRetirada;
    }

    @Column(name="OBSERVACAO", length=5000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }
}

