/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.ManifestoCteEletronico;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ProtocoloAverbacao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="AVERBACAO_CTE")
public class AverbacaoCte
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private String numDoc;
    private String serieDoc;
    private String filialDoc;
    private String linhaArq;
    private ProtocoloAverbacao protocoloAverbacao;
    private Cte cte;
    private Short tipoAverbacao = 0;
    private ManifestoCteEletronico manifestoCteEletronico;
    private NotaFiscalPropria notaFiscalPropria;

    @Id
    @Column(name="ID_AVERBACAO_CTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_AVERBACAO_CTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="NUM_DOC", length=50)
    public String getNumDoc() {
        return this.numDoc;
    }

    public void setNumDoc(String numDoc) {
        this.numDoc = numDoc;
    }

    @Column(name="SERIE_DOC", length=50)
    public String getSerieDoc() {
        return this.serieDoc;
    }

    public void setSerieDoc(String serieDoc) {
        this.serieDoc = serieDoc;
    }

    @Column(name="FILIAL_DOC", length=50)
    public String getFilialDoc() {
        return this.filialDoc;
    }

    public void setFilialDoc(String filialDoc) {
        this.filialDoc = filialDoc;
    }

    @Column(name="LINHA_ARQ", length=50)
    public String getLinhaArq() {
        return this.linhaArq;
    }

    public void setLinhaArq(String linhaArq) {
        this.linhaArq = linhaArq;
    }

    @OneToOne(fetch=FetchType.LAZY, targetEntity=ProtocoloAverbacao.class)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_PROTOCOLO_AVERBACAO", foreignKey=@ForeignKey(name="FK_AVERBACAO_CTE_PROT_AVERB"))
    public ProtocoloAverbacao getProtocoloAverbacao() {
        return this.protocoloAverbacao;
    }

    public void setProtocoloAverbacao(ProtocoloAverbacao protocoloAverbacao) {
        this.protocoloAverbacao = protocoloAverbacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CTE", foreignKey=@ForeignKey(name="FK_AVERBACAO_CTE_CTE"))
    public Cte getCte() {
        return this.cte;
    }

    public void setCte(Cte cte) {
        this.cte = cte;
    }

    @Column(name="TIPO_AVERBACAO")
    public Short getTipoAverbacao() {
        return this.tipoAverbacao;
    }

    public void setTipoAverbacao(Short tipoAverbacao) {
        this.tipoAverbacao = tipoAverbacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getNumDoc()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MANIFESTO_CTE_ELETRONICO", foreignKey=@ForeignKey(name="FK_AVERB_MAN_CTE_ELETRONICO"))
    public ManifestoCteEletronico getManifestoCteEletronico() {
        return this.manifestoCteEletronico;
    }

    public void setManifestoCteEletronico(ManifestoCteEletronico manifestoCteEletronico) {
        this.manifestoCteEletronico = manifestoCteEletronico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_PROPRIA", foreignKey=@ForeignKey(name="FK_AVERBACAO_NOTA_PROPRIA"))
    public NotaFiscalPropria getNotaFiscalPropria() {
        return this.notaFiscalPropria;
    }

    public void setNotaFiscalPropria(NotaFiscalPropria notaFiscalPropria) {
        this.notaFiscalPropria = notaFiscalPropria;
    }
}

