/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Bem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemCiapDepreciacaoBaixaBem;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="BAIXA_BEM")
public class BaixaBem
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Date dataBaixa;
    private Timestamp dataAtualizacao;
    private Double percentualBaixa = 0.0;
    private Double valorTotalDepreciacao = 0.0;
    private Double valorDepreciacaoAcumulada = 0.0;
    private Bem bem;
    private Empresa empresa;
    private BaixaBem baixaBemPrincipal;
    private LoteContabil loteContabil;
    private LancamentoCtbGerencial lancamentoGerencial;
    private ItemNotaFiscalPropria itemNotaFiscalPropria;
    private List<BaixaBem> baixasComponentesBem = new ArrayList<BaixaBem>();
    private List<ItemCiapDepreciacaoBaixaBem> itemCiapDepreciacaoBaixaBem = new ArrayList<ItemCiapDepreciacaoBaixaBem>();
    private Short nrTurnos = 0;

    @Id
    @Column(name="ID_BAIXA_BEM")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_BAIXA_BEM")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_BAIXA")
    public Date getDataBaixa() {
        return this.dataBaixa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Column(name="PERCENTUAL_BAIXA_BEM", precision=18, scale=6)
    public Double getPercentualBaixa() {
        return this.percentualBaixa;
    }

    @Column(name="VALOR_TOTAL_DEPRECIACAO", precision=18, scale=6)
    public Double getValorTotalDepreciacao() {
        return this.valorTotalDepreciacao;
    }

    @Column(name="VALOR_DEPRECIACAO_ACUMULADA", precision=18, scale=6)
    public Double getValorDepreciacaoAcumulada() {
        return this.valorDepreciacaoAcumulada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BEM", foreignKey=@ForeignKey(name="FK_BAIXA_BEM_BEM"))
    public Bem getBem() {
        return this.bem;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_BAIXA_BEM_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BAIXA_BEM_PRINCIPAL", foreignKey=@ForeignKey(name="FK_BAIXA_BEM_BAIXA"))
    public BaixaBem getBaixaBemPrincipal() {
        return this.baixaBemPrincipal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_LOTE_CONTABIL", foreignKey=@ForeignKey(name="FK_BAIXA_BEM_LOTE_CONTABIL"))
    public LoteContabil getLoteContabil() {
        return this.loteContabil;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_NOTA_FISCAL_PROPRIA", foreignKey=@ForeignKey(name="FK_BAIXA_BEM_1"))
    public ItemNotaFiscalPropria getItemNotaFiscalPropria() {
        return this.itemNotaFiscalPropria;
    }

    @OneToMany(mappedBy="baixaBemPrincipal", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<BaixaBem> getBaixasComponentesBem() {
        return this.baixasComponentesBem;
    }

    @OneToOne(targetEntity=LancamentoCtbGerencial.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LANCAMENTO_GERENCIAL", foreignKey=@ForeignKey(name="FK_BAIXA_BEM_LANC_GERENCIAL"))
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public LancamentoCtbGerencial getLancamentoGerencial() {
        return this.lancamentoGerencial;
    }

    public void setLancamentoGerencial(LancamentoCtbGerencial lancamentoGerencial) {
        this.lancamentoGerencial = lancamentoGerencial;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataBaixa(Date dataBaixa) {
        this.dataBaixa = dataBaixa;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setPercentualBaixa(Double percentualBaixa) {
        this.percentualBaixa = percentualBaixa;
    }

    public void setValorTotalDepreciacao(Double valorTotalDepreciacao) {
        this.valorTotalDepreciacao = valorTotalDepreciacao;
    }

    public void setValorDepreciacaoAcumulada(Double valorDepreciacaoAcumulada) {
        this.valorDepreciacaoAcumulada = valorDepreciacaoAcumulada;
    }

    public void setBem(Bem bem) {
        this.bem = bem;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setBaixaBemPrincipal(BaixaBem baixaBemPrincipal) {
        this.baixaBemPrincipal = baixaBemPrincipal;
    }

    public void setLoteContabil(LoteContabil loteContabil) {
        this.loteContabil = loteContabil;
    }

    public void setItemNotaFiscalPropria(ItemNotaFiscalPropria itemNotaFiscalPropria) {
        this.itemNotaFiscalPropria = itemNotaFiscalPropria;
    }

    public void setBaixasComponentesBem(List<BaixaBem> baixasComponentesBem) {
        this.baixasComponentesBem = baixasComponentesBem;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Baixa de Bem numero: {0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="baixaBem")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ItemCiapDepreciacaoBaixaBem> getItemCiapDepreciacaoBaixaBem() {
        return this.itemCiapDepreciacaoBaixaBem;
    }

    public void setItemCiapDepreciacaoBaixaBem(List<ItemCiapDepreciacaoBaixaBem> itemCiapDepreciacaoBaixaBem) {
        this.itemCiapDepreciacaoBaixaBem = itemCiapDepreciacaoBaixaBem;
    }

    @Column(name="NR_TURNOS")
    public Short getNrTurnos() {
        return this.nrTurnos;
    }

    public void setNrTurnos(Short nrTurnos) {
        this.nrTurnos = nrTurnos;
    }
}

