/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BaixaTituloPisCofins;
import com.touchcomp.basementor.model.vo.BaixaTituloSpedCofins;
import com.touchcomp.basementor.model.vo.BaixaTituloSpedPis;
import com.touchcomp.basementor.model.vo.Cheque;
import com.touchcomp.basementor.model.vo.ContasBaixa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.LancamentoSpedPisCofins;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="BAIXA_TITULO")
public class BaixaTitulo
implements InterfaceVO {
    private Long identificador;
    private Titulo titulo;
    private Double valor = 0.0;
    private Double vrJuros = 0.0;
    private Double vrDesconto = 0.0;
    private Double vrAtualizacaoMonetariaRecebida = 0.0;
    private Double vrAtualizacaoMonetariaPaga = 0.0;
    private Double vrDespBancariaPaga = 0.0;
    private Double vrDespBancariaRecebida = 0.0;
    private Double vrMulta = 0.0;
    private Double saldoBaixa = 0.0;
    private Double vrPis = 0.0;
    private Double vrConfins = 0.0;
    private Double vrIR;
    private Double vrContribSocial = 0.0;
    private Double totalOperacao = 0.0;
    private Double vrAbatimento = 0.0;
    private Double vrIofPago = 0.0;
    private Double vrIofRecebido = 0.0;
    private Double vrTaxaCartao = 0.0;
    private Cheque cheque;
    private String observacao;
    private GrupoDeBaixaFormas grupoDeBaixaFormas;
    private Boolean marcarContabilizacao;
    private ContasBaixa contasBaixa;
    private LancamentoCtbGerencial lancamentoCtbGerencial;
    private List<LancamentoCtbGerencial> lancCTbGerencialLiquidacao;
    private List<BaixaTituloSpedPis> baixaTituloSpedPis;
    private List<BaixaTituloSpedCofins> baixaTituloSpedCofins;
    private Double vrDespesaCartorioPaga;
    private Double vrDespesaCartorioRecebida;
    private Double vrMultaEmbutido;
    private Double vrJurosEmbutido;
    private Double valorAdicional;
    private Short baixarTituloTransiente;
    private List<BaixaTituloPisCofins> baixaTituloPisCofins;
    private LancamentoSpedPisCofins lancamentoPisCofins;

    public BaixaTitulo() {
        this.atualizaValorOperacao();
        this.baixaTituloSpedPis = new ArrayList<BaixaTituloSpedPis>();
        this.baixaTituloSpedCofins = new ArrayList<BaixaTituloSpedCofins>();
        this.lancCTbGerencialLiquidacao = new ArrayList<LancamentoCtbGerencial>();
        this.vrDespesaCartorioPaga = 0.0;
        this.vrDespesaCartorioRecebida = 0.0;
        this.vrMultaEmbutido = 0.0;
        this.vrJurosEmbutido = 0.0;
        this.valorAdicional = 0.0;
        this.vrIR = 0.0;
        this.baixarTituloTransiente = 0;
        this.baixaTituloPisCofins = new ArrayList<BaixaTituloPisCofins>();
    }

    @Id
    @Column(nullable=false, name="ID_BAIXA_TITULO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_BAIXA_TITULO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getTitulo()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TITULO", foreignKey=@ForeignKey(name="FK_BAIXA_TITULO_TITULO"))
    public Titulo getTitulo() {
        return this.titulo;
    }

    public void setTitulo(Titulo titulo) {
        this.titulo = titulo;
        this.atualizaValorOperacao();
    }

    @Column(nullable=false, name="VALOR", precision=12, scale=2)
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
        this.atualizaValorOperacao();
    }

    @Column(name="VR_JUROS", precision=12, scale=2)
    public Double getVrJuros() {
        return this.vrJuros;
    }

    public void setVrJuros(Double vrJuros) {
        this.vrJuros = vrJuros;
        this.atualizaValorOperacao();
    }

    @Column(name="VR_DESCONTO", precision=12, scale=2)
    public Double getVrDesconto() {
        return this.vrDesconto;
    }

    public void setVrDesconto(Double vrDesconto) {
        this.vrDesconto = vrDesconto;
        this.atualizaValorOperacao();
    }

    @Column(name="VR_ATUALIZACAO_MONETARIA_REC", precision=15, scale=2)
    public Double getVrAtualizacaoMonetariaRecebida() {
        return this.vrAtualizacaoMonetariaRecebida;
    }

    public void setVrAtualizacaoMonetariaRecebida(Double vrAtualizacaoMonetariaRecebida) {
        this.vrAtualizacaoMonetariaRecebida = vrAtualizacaoMonetariaRecebida;
        this.atualizaValorOperacao();
    }

    @Column(name="VR_ATUALIZACAO_MONETARIA_PAG", precision=15, scale=2)
    public Double getVrAtualizacaoMonetariaPaga() {
        return this.vrAtualizacaoMonetariaPaga;
    }

    public void setVrAtualizacaoMonetariaPaga(Double vrAtualizacaoMonetariaPaga) {
        this.vrAtualizacaoMonetariaPaga = vrAtualizacaoMonetariaPaga;
    }

    @Column(name="VR_MULTA", precision=12, scale=2)
    public Double getVrMulta() {
        return this.vrMulta;
    }

    public void setVrMulta(Double vrMulta) {
        this.vrMulta = vrMulta;
        this.atualizaValorOperacao();
    }

    @Column(name="VR_PIS", precision=12, scale=2)
    public Double getVrPis() {
        return this.vrPis;
    }

    public void setVrPis(Double vrPisCofinsContribSocial) {
        this.vrPis = vrPisCofinsContribSocial;
        this.atualizaValorOperacao();
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="ID_CHEQUE", foreignKey=@ForeignKey(name="FK_BAIXA_TITULO_CHEQUE"))
    public Cheque getCheque() {
        return this.cheque;
    }

    public void setCheque(Cheque cheque) {
        this.cheque = cheque;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_BAIXA_FORMAS", foreignKey=@ForeignKey(name="FK_BAIXA_TITULO_GR_BX_FR"))
    public GrupoDeBaixaFormas getGrupoDeBaixaFormas() {
        return this.grupoDeBaixaFormas;
    }

    public void setGrupoDeBaixaFormas(GrupoDeBaixaFormas grupodeBaixa) {
        this.grupoDeBaixaFormas = grupodeBaixa;
    }

    @Column(name="VR_CONFINS", precision=12, scale=2)
    public Double getVrConfins() {
        return this.vrConfins;
    }

    public void setVrConfins(Double vrConfins) {
        this.vrConfins = vrConfins;
        this.atualizaValorOperacao();
    }

    @Column(name="VR_CONTRIB_SOCIAL", precision=12, scale=2)
    public Double getVrContribSocial() {
        return this.vrContribSocial;
    }

    public void setVrContribSocial(Double vrContribSocial) {
        this.vrContribSocial = vrContribSocial;
        this.atualizaValorOperacao();
    }

    @Transient
    public Double getSaldoBaixa() {
        return this.saldoBaixa;
    }

    public void setSaldoBaixa(Double saldoBaixa) {
        this.saldoBaixa = saldoBaixa;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Transient
    public Boolean getMarcarContabilizacao() {
        return this.marcarContabilizacao;
    }

    public void setMarcarContabilizacao(Boolean marcarContabilizacao) {
        this.marcarContabilizacao = marcarContabilizacao;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTAS_BAIXA", foreignKey=@ForeignKey(name="FK_BAIXA_TITULO_CONTAS_BAIXA"))
    public ContasBaixa getContasBaixa() {
        return this.contasBaixa;
    }

    public void setContasBaixa(ContasBaixa contasBaixa) {
        this.contasBaixa = contasBaixa;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="ID_LANC_CTB_GERENCIAL", foreignKey=@ForeignKey(name="FK_BAIXA_TITULO_LANC_GER"))
    public LancamentoCtbGerencial getLancamentoCtbGerencial() {
        return this.lancamentoCtbGerencial;
    }

    public void setLancamentoCtbGerencial(LancamentoCtbGerencial lancamentoCtbGerencial) {
        this.lancamentoCtbGerencial = lancamentoCtbGerencial;
    }

    private void atualizaValorOperacao() {
        double vlr = 0.0;
        if (this.titulo != null && this.titulo.getPagRec() != null && this.titulo.getPagRec() == 0) {
            vlr = (this.valor != null ? this.valor : 0.0) - (this.vrAtualizacaoMonetariaRecebida != null ? this.vrAtualizacaoMonetariaRecebida : 0.0) + (this.vrAtualizacaoMonetariaPaga != null ? this.vrAtualizacaoMonetariaPaga : 0.0) + (this.vrDespBancariaPaga != null ? this.vrDespBancariaPaga : 0.0) + (this.vrIofPago != null ? this.vrIofPago : 0.0) - (this.vrDespBancariaRecebida != null ? this.vrDespBancariaRecebida : 0.0) - (this.vrIofRecebido != null ? this.vrIofRecebido : 0.0) + (this.vrJuros != null ? this.vrJuros : 0.0) + (this.vrMulta != null ? this.vrMulta : 0.0) + (this.vrDespesaCartorioPaga != null ? this.vrDespesaCartorioPaga : 0.0) - (this.vrDespesaCartorioRecebida != null ? this.vrDespesaCartorioRecebida : 0.0) - (this.vrConfins != null ? this.vrConfins : 0.0) - (this.vrPis != null ? this.vrPis : 0.0) - (this.vrIR != null ? this.vrIR : 0.0) - (this.vrContribSocial != null ? this.vrContribSocial : 0.0) - (this.vrDesconto != null ? this.vrDesconto : 0.0) - (this.vrAbatimento != null ? this.vrAbatimento : 0.0);
        } else if (this.titulo != null) {
            vlr = (this.valor != null ? this.valor : 0.0) + (this.vrAtualizacaoMonetariaRecebida != null ? this.vrAtualizacaoMonetariaRecebida : 0.0) - (this.vrAtualizacaoMonetariaPaga != null ? this.vrAtualizacaoMonetariaPaga : 0.0) - (this.vrDespBancariaPaga != null ? this.vrDespBancariaPaga : 0.0) - (this.vrIofPago != null ? this.vrIofPago : 0.0) + (this.vrDespBancariaRecebida != null ? this.vrDespBancariaRecebida : 0.0) + (this.vrIofRecebido != null ? this.vrIofRecebido : 0.0) + (this.vrJuros != null ? this.vrJuros : 0.0) + (this.vrMulta != null ? this.vrMulta : 0.0) - (this.vrDespesaCartorioPaga != null ? this.vrDespesaCartorioPaga : 0.0) + (this.vrDespesaCartorioRecebida != null ? this.vrDespesaCartorioRecebida : 0.0) - (this.vrConfins != null ? this.vrConfins : 0.0) - (this.vrPis != null ? this.vrPis : 0.0) - (this.vrIR != null ? this.vrIR : 0.0) - (this.vrContribSocial != null ? this.vrContribSocial : 0.0) - (this.vrDesconto != null ? this.vrDesconto : 0.0) - (this.vrTaxaCartao != null ? this.vrTaxaCartao : 0.0) - (this.vrAbatimento != null ? this.vrAbatimento : 0.0);
        }
        this.setTotalOperacao(vlr);
    }

    @Column(name="VR_DESP_BANCARIA_PAGA", precision=12, scale=2)
    public Double getVrDespBancariaPaga() {
        return this.vrDespBancariaPaga;
    }

    public void setVrDespBancariaPaga(Double vrDespBancariaPaga) {
        this.vrDespBancariaPaga = vrDespBancariaPaga;
        this.atualizaValorOperacao();
    }

    @Column(name="VR_DESP_BANCARIA_REC", precision=15, scale=2)
    public Double getVrDespBancariaRecebida() {
        return this.vrDespBancariaRecebida;
    }

    public void setVrDespBancariaRecebida(Double vrDespBancariaRecebida) {
        this.vrDespBancariaRecebida = vrDespBancariaRecebida;
        this.atualizaValorOperacao();
    }

    @Column(name="TOTAL_OPERACAO", precision=15, scale=2)
    public Double getTotalOperacao() {
        return this.totalOperacao;
    }

    public void setTotalOperacao(Double totalOperacao) {
        this.totalOperacao = totalOperacao;
    }

    @Column(name="VR_ABATIMENTO", precision=12, scale=2)
    public Double getVrAbatimento() {
        return this.vrAbatimento;
    }

    public void setVrAbatimento(Double vrAbatimento) {
        this.vrAbatimento = vrAbatimento;
    }

    @Column(name="VR_IOF_PAGO", precision=12, scale=2)
    public Double getVrIOFPago() {
        return this.vrIofPago;
    }

    public void setVrIOFPago(Double vrIofPago) {
        this.vrIofPago = vrIofPago;
    }

    @Column(name="VR_IOF_RECEBIDO", precision=12, scale=2)
    public Double getVrIOFRecebido() {
        return this.vrIofRecebido;
    }

    public void setVrIOFRecebido(Double vrIofRecebido) {
        this.vrIofRecebido = vrIofRecebido;
    }

    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinTable(name="BAIXA_TIT_LANC_CTB_GERENCIAL", joinColumns={@JoinColumn(name="ID_BAIXA_TITULO")}, inverseJoinColumns={@JoinColumn(name="ID_LANC_CTB_GERENCIAL")})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public List<LancamentoCtbGerencial> getLancCTbGerencialLiquidacao() {
        return this.lancCTbGerencialLiquidacao;
    }

    public void setLancCTbGerencialLiquidacao(List<LancamentoCtbGerencial> lancCTbGerencialLiquidacao) {
        this.lancCTbGerencialLiquidacao = lancCTbGerencialLiquidacao;
    }

    @OneToMany(mappedBy="baixaTitulo", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public List<BaixaTituloSpedPis> getBaixaTituloSpedPis() {
        return this.baixaTituloSpedPis;
    }

    public void setBaixaTituloSpedPis(List<BaixaTituloSpedPis> baixaTituloSpedPis) {
        this.baixaTituloSpedPis = baixaTituloSpedPis;
    }

    @OneToMany(mappedBy="baixaTitulo", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public List<BaixaTituloSpedCofins> getBaixaTituloSpedCofins() {
        return this.baixaTituloSpedCofins;
    }

    public void setBaixaTituloSpedCofins(List<BaixaTituloSpedCofins> baixaTituloSpedCofins) {
        this.baixaTituloSpedCofins = baixaTituloSpedCofins;
    }

    @Column(name="VR_DESPESA_CARTORIO", precision=15, scale=2)
    public Double getVrDespesaCartorioPaga() {
        return this.vrDespesaCartorioPaga;
    }

    public void setVrDespesaCartorioPaga(Double vrDespesaCartorioPaga) {
        this.vrDespesaCartorioPaga = vrDespesaCartorioPaga;
    }

    @Column(name="VR_DESPESA_CARTORIO_REC", precision=15, scale=2)
    public Double getVrDespesaCartorioRecebida() {
        return this.vrDespesaCartorioRecebida;
    }

    public void setVrDespesaCartorioRecebida(Double vrDespesaCartorioRecebida) {
        this.vrDespesaCartorioRecebida = vrDespesaCartorioRecebida;
    }

    @Column(name="VR_MULTA_EMBUTIDO", precision=15, scale=2)
    public Double getVrMultaEmbutido() {
        return this.vrMultaEmbutido;
    }

    public void setVrMultaEmbutido(Double vrMultaEmbutido) {
        this.vrMultaEmbutido = vrMultaEmbutido;
    }

    @Column(name="VR_JUROS_EMBUTIDO", precision=15, scale=2)
    public Double getVrJurosEmbutido() {
        return this.vrJurosEmbutido;
    }

    public void setVrJurosEmbutido(Double vrJurosEmbutido) {
        this.vrJurosEmbutido = vrJurosEmbutido;
    }

    @Column(name="VALOR_ADICIONAL", precision=15, scale=2)
    public Double getValorAdicional() {
        return this.valorAdicional;
    }

    public void setValorAdicional(Double valorAdicional) {
        this.valorAdicional = valorAdicional;
    }

    @Column(name="VALOR_IR", precision=15, scale=2)
    public Double getVrIR() {
        return this.vrIR;
    }

    public void setVrIR(Double vrIR) {
        this.vrIR = vrIR;
    }

    @Transient
    public Short getBaixarTituloTransiente() {
        return this.baixarTituloTransiente;
    }

    public void setBaixarTituloTransiente(Short baixarTituloTransiente) {
        this.baixarTituloTransiente = baixarTituloTransiente;
    }

    @OneToMany(mappedBy="baixaTitulo", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<BaixaTituloPisCofins> getBaixaTituloPisCofins() {
        return this.baixaTituloPisCofins;
    }

    public void setBaixaTituloPisCofins(List<BaixaTituloPisCofins> baixaTituloPisCofins) {
        this.baixaTituloPisCofins = baixaTituloPisCofins;
    }

    @Column(name="VR_TAXA_CARTAO", precision=15, scale=2)
    public Double getVrTaxaCartao() {
        return this.vrTaxaCartao;
    }

    public void setVrTaxaCartao(Double vrTaxaCartao) {
        this.vrTaxaCartao = vrTaxaCartao;
        this.atualizaValorOperacao();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="ID_LANCAMENTO_PIS_COFINS", foreignKey=@ForeignKey(name="FK_BAIXA_TITULO_LANC_PIS_COFINS"))
    public LancamentoSpedPisCofins getLancamentoPisCofins() {
        return this.lancamentoPisCofins;
    }

    public void setLancamentoPisCofins(LancamentoSpedPisCofins lancamentoPisCofins) {
        this.lancamentoPisCofins = lancamentoPisCofins;
    }
}

