/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Bem;
import com.touchcomp.basementor.model.vo.IdentBemImobilizado;
import com.touchcomp.basementor.model.vo.IncidenciaPisCofins;
import com.touchcomp.basementor.model.vo.IndOrigCredBemPisCofins;
import com.touchcomp.basementor.model.vo.IndicadorNrParcelasSpedPisCofins;
import com.touchcomp.basementor.model.vo.IndicadorUtilBemImobilizado;
import com.touchcomp.basementor.model.vo.NaturezaBCCredito;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.ProcessoFiscal;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="BEM_SPED_PISCOFINS")
public class BemSpedPisCofins
implements InterfaceVO {
    private Long identificador;
    private Bem bem;
    private NaturezaBCCredito naturezaBCCredito;
    private IdentBemImobilizado idenBemImobilizado;
    private IndOrigCredBemPisCofins indOrigCredBemPisCofins;
    private IndicadorUtilBemImobilizado indUtilBemImobilizado;
    private Date mesOperAquis;
    private Double vrOperAquis = 0.0;
    private Double parcOperNaoBcCred = 0.0;
    private Double vrBcCred = 0.0;
    private Short nrParcela = 1;
    private Double aliquotaPis = 0.0;
    private Double aliquotaCofins = 0.0;
    private PlanoConta planoConta;
    private String descricaoBemImobilizado;
    private ProcessoFiscal processoFiscal;
    private IncidenciaPisCofins cstPis;
    private IncidenciaPisCofins cstCofins;
    private IndicadorNrParcelasSpedPisCofins indNrParcela;
    private Short nrParcelaInicial = 1;

    @Id
    @Column(name="ID_BEM_SPED_PISCOFINS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_BEM_SPED_PISCOFINS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_BEM", foreignKey=@ForeignKey(name="FK_BEM_SPED_PISCOFINS_BEM"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Bem getBem() {
        return this.bem;
    }

    public void setBem(Bem bem) {
        this.bem = bem;
    }

    @JoinColumn(name="ID_NATUREZA_BC_CRED", foreignKey=@ForeignKey(name="FK_BEM_SPED_PISCOFINS_NAT_BC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public NaturezaBCCredito getNaturezaBCCredito() {
        return this.naturezaBCCredito;
    }

    public void setNaturezaBCCredito(NaturezaBCCredito naturezaBCCredito) {
        this.naturezaBCCredito = naturezaBCCredito;
    }

    @JoinColumn(name="ID_IDENT_BEM_IMOB", foreignKey=@ForeignKey(name="FK_BEM_SPED_PISCOFINS_IDENT_BEM"))
    @ManyToOne(fetch=FetchType.LAZY)
    public IdentBemImobilizado getIdenBemImobilizado() {
        return this.idenBemImobilizado;
    }

    public void setIdenBemImobilizado(IdentBemImobilizado idenBemImobilizado) {
        this.idenBemImobilizado = idenBemImobilizado;
    }

    @JoinColumn(name="ID_IND_ORIG_CR_BEMPISCOFINS", foreignKey=@ForeignKey(name="FK_BEM_SPED_PISCOFINS_INDORIG"))
    @ManyToOne(fetch=FetchType.LAZY)
    public IndOrigCredBemPisCofins getIndOrigCredBemPisCofins() {
        return this.indOrigCredBemPisCofins;
    }

    public void setIndOrigCredBemPisCofins(IndOrigCredBemPisCofins indOrigCredBemPisCofins) {
        this.indOrigCredBemPisCofins = indOrigCredBemPisCofins;
    }

    @JoinColumn(name="ID_IND_UTIL_BEM_IMOB", foreignKey=@ForeignKey(name="FK_BEM_SPED_PISCOFINS_INDUTIL"))
    @ManyToOne(fetch=FetchType.LAZY)
    public IndicadorUtilBemImobilizado getIndUtilBemImobilizado() {
        return this.indUtilBemImobilizado;
    }

    public void setIndUtilBemImobilizado(IndicadorUtilBemImobilizado indUtilBemImobilizado) {
        this.indUtilBemImobilizado = indUtilBemImobilizado;
    }

    @Column(name="PARC_OPER_NAO_BC_CRED", precision=15, scale=2)
    public Double getParcOperNaoBcCred() {
        return this.parcOperNaoBcCred;
    }

    public void setParcOperNaoBcCred(Double parcOperNaoBcCred) {
        this.parcOperNaoBcCred = parcOperNaoBcCred;
    }

    @Column(name="ALIQUOTA_PIS", precision=15, scale=2)
    public Double getAliquotaPis() {
        return this.aliquotaPis;
    }

    public void setAliquotaPis(Double aliquotaPis) {
        this.aliquotaPis = aliquotaPis;
    }

    @Column(name="ALIQUOTA_COFINS", precision=15, scale=2)
    public Double getAliquotaCofins() {
        return this.aliquotaCofins;
    }

    public void setAliquotaCofins(Double aliquotaCofins) {
        this.aliquotaCofins = aliquotaCofins;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_BEM_SPED_PISCOFINS_PC"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.bem});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="MES_OPER_AQUIS")
    public Date getMesOperAquis() {
        return this.mesOperAquis;
    }

    public void setMesOperAquis(Date mesOperAquis) {
        this.mesOperAquis = mesOperAquis;
    }

    @Column(name="VR_OPER_AQUIS", precision=15, scale=2)
    public Double getVrOperAquis() {
        return this.vrOperAquis;
    }

    public void setVrOperAquis(Double vrOperAquis) {
        this.vrOperAquis = vrOperAquis;
    }

    @Column(name="VR_BC_CRED", precision=15, scale=2)
    public Double getVrBcCred() {
        return this.vrBcCred;
    }

    public void setVrBcCred(Double vrBcCred) {
        this.vrBcCred = vrBcCred;
    }

    @Column(name="NR_PARCELA")
    public Short getNrParcela() {
        return this.nrParcela;
    }

    public void setNrParcela(Short nrParcela) {
        this.nrParcela = nrParcela;
    }

    @Column(name="DESC_BEM_IMOB", length=250)
    public String getDescricaoBemImobilizado() {
        return this.descricaoBemImobilizado;
    }

    public void setDescricaoBemImobilizado(String descricaoBemImobilizado) {
        this.descricaoBemImobilizado = descricaoBemImobilizado;
    }

    @JoinColumn(name="ID_PROCESSO_FISCAL", foreignKey=@ForeignKey(name="FK_BEM_SPED_PISCOFINS_PROC_FISC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ProcessoFiscal getProcessoFiscal() {
        return this.processoFiscal;
    }

    public void setProcessoFiscal(ProcessoFiscal processoFiscal) {
        this.processoFiscal = processoFiscal;
    }

    @JoinColumn(name="ID_INCIDENCIA_PIS", foreignKey=@ForeignKey(name="FK_BEM_SPED_PISCOFINS_PIS"))
    @ManyToOne(fetch=FetchType.LAZY)
    public IncidenciaPisCofins getCstPis() {
        return this.cstPis;
    }

    public void setCstPis(IncidenciaPisCofins cstPis) {
        this.cstPis = cstPis;
    }

    @JoinColumn(name="ID_INCIDENCIA_COFINS", foreignKey=@ForeignKey(name="FK_BEM_SPED_PISCOFINS_INC_COFIN"))
    @ManyToOne(fetch=FetchType.LAZY)
    public IncidenciaPisCofins getCstCofins() {
        return this.cstCofins;
    }

    public void setCstCofins(IncidenciaPisCofins cstCofins) {
        this.cstCofins = cstCofins;
    }

    @JoinColumn(name="ID_IND_NR_PARC", foreignKey=@ForeignKey(name="FK_BEM_SPED_PISCOFINS_IND_NR_P"))
    @ManyToOne(fetch=FetchType.LAZY)
    public IndicadorNrParcelasSpedPisCofins getIndNrParcela() {
        return this.indNrParcela;
    }

    public void setIndNrParcela(IndicadorNrParcelasSpedPisCofins indNrParcela) {
        this.indNrParcela = indNrParcela;
    }

    @Column(name="NR_PARCELA_INICIAL")
    public Short getNrParcelaInicial() {
        return this.nrParcelaInicial;
    }

    public void setNrParcelaInicial(Short nrParcelaInicial) {
        this.nrParcelaInicial = nrParcelaInicial;
    }
}

