/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Bem;
import com.touchcomp.basementor.model.vo.TipoDepreciacao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="BEM_TIPO_DEPRECIACAO", uniqueConstraints={@UniqueConstraint(name="UNQ1_BEM_TIPO_DEPRECIACAO", columnNames={"ID_TIPO_DEPRECIACAO", "ID_BEM"})})
public class BemTipoDepreciacao
implements InterfaceVO {
    private Long identificador;
    private TipoDepreciacao tipoDepreciacao;
    private Bem bem;
    private Date dataInicial;
    private Double valor = 0.0;
    private Short deprTotalmente = 0;

    @Id
    @Column(nullable=false, name="ID_BEM_TIPO_DEPRECIACAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_BEM_TIPO_DEPRECIACAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_TIPO_DEPRECIACAO", foreignKey=@ForeignKey(name="FK_BEM_TIPO_DEPRECIACAO_TP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoDepreciacao getTipoDepreciacao() {
        return this.tipoDepreciacao;
    }

    public void setTipoDepreciacao(TipoDepreciacao tipoDepreciacao) {
        this.tipoDepreciacao = tipoDepreciacao;
    }

    @JoinColumn(name="ID_BEM", foreignKey=@ForeignKey(name="FK_BEM_TIPO_DEPRECIACAO_BEM"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Bem getBem() {
        return this.bem;
    }

    public void setBem(Bem bem) {
        this.bem = bem;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Column(name="VALOR", precision=15, scale=2)
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.bem});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="DEPR_TOTALMENTE")
    public Short getDeprTotalmente() {
        return this.deprTotalmente;
    }

    public void setDeprTotalmente(Short deprTotalmente) {
        this.deprTotalmente = deprTotalmente;
    }
}

