/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.ConstantsBombaCombustivel;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BicoBombaCombustivel;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Fabricante;
import com.touchcomp.basementor.model.vo.LacreBombaCombustivel;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="BOMBA_COMBUSTIVEL", uniqueConstraints={@UniqueConstraint(name="UNQ1_BOMBA_COMBUSTIVEL", columnNames={"DESCRICAO"})})
public class BombaCombustivel
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private String descricao;
    private List<BicoBombaCombustivel> bicos = new ArrayList<BicoBombaCombustivel>();
    private Short ativo = 1;
    private Integer numeroBomba = 0;
    private Empresa empresa;
    private String serie;
    private Fabricante fabricante;
    private String modelo;
    private Short tipoMedicao;
    private Short nrCasasMedidor = 0;
    private Short nrCasasMedidorSuportada = 0;
    private Double medicaoInicial = 0.0;
    private List<LacreBombaCombustivel> lacres = new ArrayList<LacreBombaCombustivel>();
    private Date dataDesativacao;

    public BombaCombustivel() {
        this.tipoMedicao = ConstantsBombaCombustivel.MEDICAO_ANALOGICA;
    }

    @Id
    @Column(nullable=false, name="ID_BOMBA_COMBUSTIVEL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_BOMBA_COMBUSTIVEL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DESCRICAO", length=100, unique=true)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @OneToMany(targetEntity=BicoBombaCombustivel.class, mappedBy="bombaCombustivel", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<BicoBombaCombustivel> getBicos() {
        return this.bicos;
    }

    public void setBicos(List<BicoBombaCombustivel> bicos) {
        this.bicos = bicos;
    }

    @OneToMany(targetEntity=LacreBombaCombustivel.class, mappedBy="bombaCombustivel", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<LacreBombaCombustivel> getLacres() {
        return this.lacres;
    }

    public void setLacres(List<LacreBombaCombustivel> lacres) {
        this.lacres = lacres;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="NUMERO_BOMBA")
    public Integer getNumeroBomba() {
        return this.numeroBomba;
    }

    public void setNumeroBomba(Integer numeroBomba) {
        this.numeroBomba = numeroBomba;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getDescricao() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_BOMBA_COMBUSTIVEL_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="SERIE", length=50)
    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String serie) {
        this.serie = serie;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FABRICANTE", foreignKey=@ForeignKey(name="FK_BOMBA_COMBUSTIVEL_FABRICANTE"))
    public Fabricante getFabricante() {
        return this.fabricante;
    }

    public void setFabricante(Fabricante fabricante) {
        this.fabricante = fabricante;
    }

    @Column(name="MODELO", length=100)
    public String getModelo() {
        return this.modelo;
    }

    public void setModelo(String modelo) {
        this.modelo = modelo;
    }

    @Column(name="TIPO_MEDICAO")
    public Short getTipoMedicao() {
        return this.tipoMedicao;
    }

    public void setTipoMedicao(Short tipoMedicao) {
        this.tipoMedicao = tipoMedicao;
    }

    @Column(name="NR_CASAS_MEDIDOR")
    public Short getNrCasasMedidor() {
        return this.nrCasasMedidor;
    }

    public void setNrCasasMedidor(Short nrCasasMedidor) {
        this.nrCasasMedidor = nrCasasMedidor;
    }

    @Column(name="NR_CASAS_MEDIDOR_SUPORTADA")
    public Short getNrCasasMedidorSuportada() {
        return this.nrCasasMedidorSuportada;
    }

    public void setNrCasasMedidorSuportada(Short nrCasasMedidorSuportada) {
        this.nrCasasMedidorSuportada = nrCasasMedidorSuportada;
    }

    @Column(name="MEDICAO_INICIAL")
    public Double getMedicaoInicial() {
        return this.medicaoInicial;
    }

    public void setMedicaoInicial(Double medicaoInicial) {
        this.medicaoInicial = medicaoInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="data_desativacao")
    public Date getDataDesativacao() {
        return this.dataDesativacao;
    }

    public void setDataDesativacao(Date dataDesativacao) {
        this.dataDesativacao = dataDesativacao;
    }
}

