/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.datatransfer.IgnorePropEntityTransfer;
import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.constants.enums.bi.EnumConstBusinessIntTipoTemplate;
import com.touchcomp.basementor.constants.enums.bi.EnumConstBusinessIntelligenceTipo;
import com.touchcomp.basementor.constants.enums.businessintelligence.EnumConstBITipoGeracao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BusinessIntConsArq;
import com.touchcomp.basementor.model.vo.BusinessIntConsHQL;
import com.touchcomp.basementor.model.vo.BusinessIntConsSQL;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceDados;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceFiles;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceFormGer;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceInf;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceObjetos;
import com.touchcomp.basementor.model.vo.BusinessJavaClassCode;
import com.touchcomp.basementor.model.vo.DadoAdicionalBI;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.IndexColumn;

@Entity
@Table(name="BUSINESS_INTELLIGENCE", uniqueConstraints={@UniqueConstraint(name="UNQ1_BUSINESS_INTELLIGENCE", columnNames={"ID_BUSINESS_JAVA_CLASS_CODE"}), @UniqueConstraint(name="UNQ2_BUSINESS_INTELLIGENCE", columnNames={"ID_BUSINESS_INTEL_OBJ"}), @UniqueConstraint(name="UNQ3_BUSINESS_INTELLIGENCE", columnNames={"ID_BUSINESS_INT_CONS_SQL"}), @UniqueConstraint(name="UNQ4_BUSINESS_INTELLIGENCE", columnNames={"ID_BUSINESS_INT_CONS_HQL"})})
public class BusinessIntelligence
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private String observacao;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private Empresa empresa;
    private Short liberarPdf = 0;
    private Short liberarWord = 0;
    private Short liberarExcel = 0;
    private Short liberarVisualizacao = 0;
    private Short liberarODT = 0;
    private Short liberarExcelDireto = 0;
    private Short liberarHTML = 0;
    private Short tipoBI = 0;
    private Short tipoClassificacaoBI;
    private Long numeroBI;
    private List<DadoAdicionalBI> dadosAdicionalBI = new ArrayList<DadoAdicionalBI>();
    private BusinessIntelligenceObjetos businessIntelligenceObjetos;
    private List<BusinessIntelligenceFiles> businessIntelligenceFiles = new ArrayList<BusinessIntelligenceFiles>();
    private BusinessIntConsSQL businessIntConsSQL;
    private BusinessIntConsHQL businessIntConsHQL;
    private BusinessIntConsArq businessIntConsArq;
    private List<BusinessIntelligenceDados> dadosImagens = new ArrayList<BusinessIntelligenceDados>();
    private Pessoa pessoaResponsavel;
    private Long numeroVersao = 1L;
    private BusinessJavaClassCode businessJavaClassCode;
    private String serialLocalBI;
    private Long numeroVersaoRep = 1L;
    private List<BusinessIntelligenceFormGer> formatosGeracao = new ArrayList<BusinessIntelligenceFormGer>();
    private Integer nrVersaoEstruturaBI = 2;
    private String caminhoJrxmlLayoutDef;
    private Short carregarAuto = 0;
    private String tituloRelatorio;
    private String numeroControle;
    private Short ativo = 1;
    private String motivoInativacao;
    private Short naoVersionarAuto = 0;
    private Usuario usuNaoVersionarAuto;
    private String codigoDocumentacao;
    private BusinessIntelligenceInf businessIntelligenceInf;
    private Short tipoTemplate;

    public BusinessIntelligence() {
        this.tipoClassificacaoBI = EnumConstBusinessIntelligenceTipo.RELATORIO_LISTAGEM.getValue();
        this.tipoTemplate = EnumConstBusinessIntTipoTemplate.JASPER_PRINT.getValue();
    }

    @Id
    @Column(nullable=false, name="ID_BUSINESS_INTELLIGENCE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_BUSINESS_INTELLIGENCE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_BUSINESS_INTELLIGENCE_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        EnumConstBITipoGeracao tp = EnumConstBITipoGeracao.get((int)this.getTipoBI().shortValue());
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getDescricao(), tp != null ? tp.getDescricao() : "NA"});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="OBSERVACAO", length=2000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="LIBERAR_PDF")
    public Short getLiberarPdf() {
        return this.liberarPdf;
    }

    public void setLiberarPdf(Short liberarPdf) {
        this.liberarPdf = liberarPdf;
    }

    @Column(name="LIBERAR_WORD")
    public Short getLiberarWord() {
        return this.liberarWord;
    }

    public void setLiberarWord(Short liberarWord) {
        this.liberarWord = liberarWord;
    }

    @Column(name="LIBERAR_EXCEL")
    public Short getLiberarExcel() {
        return this.liberarExcel;
    }

    public void setLiberarExcel(Short liberarExcel) {
        this.liberarExcel = liberarExcel;
    }

    @Column(name="LIBERAR_VISUALIZACAO")
    public Short getLiberarVisualizacao() {
        return this.liberarVisualizacao;
    }

    public void setLiberarVisualizacao(Short liberarVisualizacao) {
        this.liberarVisualizacao = liberarVisualizacao;
    }

    @Column(name="LIBERAR_ODT")
    public Short getLiberarODT() {
        return this.liberarODT;
    }

    public void setLiberarODT(Short liberarODT) {
        this.liberarODT = liberarODT;
    }

    @Column(name="LIBERAR_EXCEL_DIRETO")
    public Short getLiberarExcelDireto() {
        return this.liberarExcelDireto;
    }

    public void setLiberarExcelDireto(Short liberarExcelDireto) {
        this.liberarExcelDireto = liberarExcelDireto;
    }

    @Column(name="LIBERAR_HTML")
    public Short getLiberarHTML() {
        return this.liberarHTML;
    }

    public void setLiberarHTML(Short liberarHTML) {
        this.liberarHTML = liberarHTML;
    }

    @OneToMany(mappedBy="businessInteligence", cascade={CascadeType.ALL}, orphanRemoval=true)
    @IndexColumn(name="indice")
    public List<DadoAdicionalBI> getDadosAdicionalBI() {
        return this.dadosAdicionalBI;
    }

    public void setDadosAdicionalBI(List<DadoAdicionalBI> dadosAdicionalBI) {
        this.dadosAdicionalBI = dadosAdicionalBI;
    }

    @OneToOne(targetEntity=BusinessIntelligenceObjetos.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="ID_BUSINESS_INTEL_OBJ", foreignKey=@ForeignKey(name="FK_BUSINESS_INTELLIGENCE_BI_OBJ"))
    public BusinessIntelligenceObjetos getBusinessIntelligenceObjetos() {
        return this.businessIntelligenceObjetos;
    }

    public void setBusinessIntelligenceObjetos(BusinessIntelligenceObjetos businessIntelligenceObjetos) {
        this.businessIntelligenceObjetos = businessIntelligenceObjetos;
    }

    @Column(name="TIPO_BI")
    public Short getTipoBI() {
        return this.tipoBI;
    }

    public void setTipoBI(Short tipoBI) {
        this.tipoBI = tipoBI;
    }

    @OneToMany(mappedBy="businessIntelligence", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<BusinessIntelligenceFiles> getBusinessIntelligenceFiles() {
        return this.businessIntelligenceFiles;
    }

    public void setBusinessIntelligenceFiles(List<BusinessIntelligenceFiles> businessIntelligenceFiles) {
        this.businessIntelligenceFiles = businessIntelligenceFiles;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_BUSINESS_INT_CONS_SQL", foreignKey=@ForeignKey(name="FK_BUSINESS_INTELLIGENCE_BU_SQL"))
    public BusinessIntConsSQL getBusinessIntConsSQL() {
        return this.businessIntConsSQL;
    }

    public void setBusinessIntConsSQL(BusinessIntConsSQL businessIntConsSQL) {
        this.businessIntConsSQL = businessIntConsSQL;
    }

    @OneToMany(mappedBy="businessIntelligence", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<BusinessIntelligenceDados> getDadosImagens() {
        return this.dadosImagens;
    }

    public void setDadosImagens(List<BusinessIntelligenceDados> dadosImagens) {
        this.dadosImagens = dadosImagens;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_RESPONSAVEL", foreignKey=@ForeignKey(name="FK_BUSINESS_INTELLIGENCE_PESSOA"))
    public Pessoa getPessoaResponsavel() {
        return this.pessoaResponsavel;
    }

    public void setPessoaResponsavel(Pessoa pessoaResponsavel) {
        this.pessoaResponsavel = pessoaResponsavel;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_BUSINESS_JAVA_CLASS_CODE", foreignKey=@ForeignKey(name="FK_BUSINESS_INTELLIGENCE_JAVA_C"))
    public BusinessJavaClassCode getBusinessJavaClassCode() {
        return this.businessJavaClassCode;
    }

    public void setBusinessJavaClassCode(BusinessJavaClassCode businessJavaClassCode) {
        this.businessJavaClassCode = businessJavaClassCode;
    }

    @Column(name="SERIAL_LOCAL_BI", length=34)
    public String getSerialLocalBI() {
        return this.serialLocalBI;
    }

    public void setSerialLocalBI(String serialLocalBI) {
        this.serialLocalBI = serialLocalBI;
    }

    @Column(name="NUMERO_VERSAO_REP")
    public Long getNumeroVersaoRep() {
        return this.numeroVersaoRep;
    }

    public void setNumeroVersaoRep(Long numeroVersaoRep) {
        this.numeroVersaoRep = numeroVersaoRep;
    }

    @Column(name="NUMERO_VERSAO")
    public Long getNumeroVersao() {
        return this.numeroVersao;
    }

    public void setNumeroVersao(Long numeroVersao) {
        this.numeroVersao = numeroVersao;
    }

    @OneToMany(mappedBy="businessIntelligence", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<BusinessIntelligenceFormGer> getFormatosGeracao() {
        return this.formatosGeracao;
    }

    public void setFormatosGeracao(List<BusinessIntelligenceFormGer> formatosGeracao) {
        this.formatosGeracao = formatosGeracao;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_BUSINESS_INT_CONS_HQL", foreignKey=@ForeignKey(name="FK_BUSINESS_INTELLIGENCE_BI_HQL"))
    public BusinessIntConsHQL getBusinessIntConsHQL() {
        return this.businessIntConsHQL;
    }

    public void setBusinessIntConsHQL(BusinessIntConsHQL businessIntConsHQL) {
        this.businessIntConsHQL = businessIntConsHQL;
    }

    @Column(name="NR_VERSAO_ESTRUTURA_BI")
    public Integer getNrVersaoEstruturaBI() {
        return this.nrVersaoEstruturaBI;
    }

    public void setNrVersaoEstruturaBI(Integer nrVersaoEstruturaBI) {
        this.nrVersaoEstruturaBI = nrVersaoEstruturaBI;
    }

    @IgnorePropEntityTransfer
    @Column(name="CAMINHO_JRXML_LAYOUT_DEF", length=1500)
    public String getCaminhoJrxmlLayoutDef() {
        return this.caminhoJrxmlLayoutDef;
    }

    public void setCaminhoJrxmlLayoutDef(String caminhoJrxmlLayoutDef) {
        this.caminhoJrxmlLayoutDef = caminhoJrxmlLayoutDef;
    }

    @Column(name="CARREGAR_AUTO")
    public Short getCarregarAuto() {
        return this.carregarAuto;
    }

    public void setCarregarAuto(Short carregarAuto) {
        this.carregarAuto = carregarAuto;
    }

    @Column(name="TITULO_RELATORIO", length=500)
    public String getTituloRelatorio() {
        return this.tituloRelatorio;
    }

    public void setTituloRelatorio(String tituloRelatorio) {
        this.tituloRelatorio = tituloRelatorio;
    }

    @Column(name="NUMERO_CONTROLE", length=20)
    public String getNumeroControle() {
        return this.numeroControle;
    }

    public void setNumeroControle(String numeroControle) {
        this.numeroControle = numeroControle;
    }

    @Column(nullable=false, name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @IgnorePropEntityTransfer
    @Column(name="MOTIVO_INATIVACAO", length=500)
    public String getMotivoInativacao() {
        return this.motivoInativacao;
    }

    public void setMotivoInativacao(String motivoInativacao) {
        this.motivoInativacao = motivoInativacao;
    }

    @IgnorePropEntityTransfer
    @Column(nullable=false, name="NAO_VERSIONAR_AUTO")
    public Short getNaoVersionarAuto() {
        return this.naoVersionarAuto;
    }

    public void setNaoVersionarAuto(Short naoVersionarAuto) {
        this.naoVersionarAuto = naoVersionarAuto;
    }

    @IgnorePropEntityTransfer
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USU_NAO_VERS_AUTO", foreignKey=@ForeignKey(name="FK_BUSINESS_INT_USU_NAO_VERS"))
    public Usuario getUsuNaoVersionarAuto() {
        return this.usuNaoVersionarAuto;
    }

    public void setUsuNaoVersionarAuto(Usuario usuNaoVersionarAuto) {
        this.usuNaoVersionarAuto = usuNaoVersionarAuto;
    }

    @Column(name="CODIGO_DOCUMENTACAO", length=100)
    public String getCodigoDocumentacao() {
        return this.codigoDocumentacao;
    }

    public void setCodigoDocumentacao(String codigoDocumentacao) {
        this.codigoDocumentacao = codigoDocumentacao;
    }

    @Column(name="TIPO_CLASSIFICACAO_BI")
    public Short getTipoClassificacaoBI() {
        return this.tipoClassificacaoBI;
    }

    public void setTipoClassificacaoBI(Short tipoClassificacaoBI) {
        this.tipoClassificacaoBI = tipoClassificacaoBI;
    }

    @Ignore
    @Column(name="NUMERO_BI")
    public Long getNumeroBI() {
        return this.numeroBI;
    }

    public void setNumeroBI(Long numeroBI) {
        this.numeroBI = numeroBI;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_BUSINESS_INT_CONS_ARQ", foreignKey=@ForeignKey(name="FK_BUSINESS_INTELLIGENCE_BI_ARQ"))
    public BusinessIntConsArq getBusinessIntConsArq() {
        return this.businessIntConsArq;
    }

    public void setBusinessIntConsArq(BusinessIntConsArq businessIntConsArq) {
        this.businessIntConsArq = businessIntConsArq;
    }

    @IgnorePropEntityTransfer
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_BUSINESS_INTELLIGENCE_INF", foreignKey=@ForeignKey(name="FK_BUSINESS_INTELLIGENCE_BI_INF"))
    public BusinessIntelligenceInf getBusinessIntelligenceInf() {
        return this.businessIntelligenceInf;
    }

    public void setBusinessIntelligenceInf(BusinessIntelligenceInf businessIntelligenceInf) {
        this.businessIntelligenceInf = businessIntelligenceInf;
    }

    @Column(name="TIPO_TEMPLATE")
    public Short getTipoTemplate() {
        return this.tipoTemplate;
    }

    public void setTipoTemplate(Short tipoTemplate) {
        this.tipoTemplate = tipoTemplate;
    }
}

