/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.bi.EnumConstBusinessIntelligencePref;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AssinaturaEletBIPrefBI;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.BusinessIntelligencePrefAss;
import com.touchcomp.basementor.model.vo.FormatoGeracaoBI;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="BUSINESS_INT_PREF")
public class BusinessIntelligencePref
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private String dadosUtilizados;
    private Short preferenciaPadrao = 0;
    private Short tipo;
    private BusinessIntelligence businessIntelligence;
    private FormatoGeracaoBI formatoSaidaSel;
    private Usuario usuario;
    private List<BusinessIntelligencePrefAss> assinaturasBI;
    private String fechoBI;
    private AssinaturaEletBIPrefBI assinaturaEletronicaBIPref;

    public BusinessIntelligencePref() {
        this.tipo = EnumConstBusinessIntelligencePref.PREF_POR_USUARIO.value;
        this.assinaturasBI = new LinkedList<BusinessIntelligencePrefAss>();
    }

    @Id
    @Column(nullable=false, name="ID_BUSINESS_INT_PREF")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_BUSINESS_INT_PREF")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="DADOS_UTILIZADOS")
    public String getDadosUtilizados() {
        return this.dadosUtilizados;
    }

    public void setDadosUtilizados(String dadosUtilizados) {
        this.dadosUtilizados = dadosUtilizados;
    }

    @Column(name="PREFERENCIA_PADRAO")
    public Short getPreferenciaPadrao() {
        return this.preferenciaPadrao;
    }

    public void setPreferenciaPadrao(Short preferenciaPadrao) {
        this.preferenciaPadrao = preferenciaPadrao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BUSINESS_INTELLIGENCE", foreignKey=@ForeignKey(name="FK_BUSINESS_INT_PREF_BI"))
    public BusinessIntelligence getBusinessIntelligence() {
        return this.businessIntelligence;
    }

    public void setBusinessIntelligence(BusinessIntelligence businessIntelligence) {
        this.businessIntelligence = businessIntelligence;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}({1})", (Object[])new Object[]{this.getDescricao(), this.getBusinessIntelligence() != null ? this.getBusinessIntelligence().getDescricao() : ""});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FORMATO_SAIDA_SEL", foreignKey=@ForeignKey(name="FK_BUSINESS_INT_PREF_FORM_GER_B"))
    public FormatoGeracaoBI getFormatoSaidaSel() {
        return this.formatoSaidaSel;
    }

    public void setFormatoSaidaSel(FormatoGeracaoBI formatoSaidaSel) {
        this.formatoSaidaSel = formatoSaidaSel;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_BUSINESS_INT_PREF_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Column(name="TIPO")
    public Short getTipo() {
        return this.tipo;
    }

    public void setTipo(Short tipo) {
        this.tipo = tipo;
    }

    @OneToMany(mappedBy="businessIntelligencePref", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<BusinessIntelligencePrefAss> getAssinaturasBI() {
        return this.assinaturasBI;
    }

    public void setAssinaturasBI(List<BusinessIntelligencePrefAss> assinaturasBI) {
        this.assinaturasBI = assinaturasBI;
    }

    @Column(name="FECHO_BI")
    public String getFechoBI() {
        return this.fechoBI;
    }

    public void setFechoBI(String fechoBI) {
        this.fechoBI = fechoBI;
    }

    @OneToOne(mappedBy="businessIntelligencePref", optional=true)
    public AssinaturaEletBIPrefBI getAssinaturaEletronicaBIPref() {
        return this.assinaturaEletronicaBIPref;
    }

    public void setAssinaturaEletronicaBIPref(AssinaturaEletBIPrefBI assinaturaEletronicaBIPref) {
        this.assinaturaEletronicaBIPref = assinaturaEletronicaBIPref;
    }
}

