/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="CNAE", uniqueConstraints={@UniqueConstraint(name="UNQ1_CNAE", columnNames={"CODIGO"})})
public class CNAE
implements InterfaceVO {
    private Long identificador;
    private String codigo;
    private String descricao;
    private Double percPresuncaoCSLL = 0.0;
    private Double percPresuncaoIRPJ = 0.0;
    private Timestamp dataAtualizacao;
    private String desmembramento;
    private Double aliquotaCSLL = 0.0;
    private Double aliquotaIRPJ = 0.0;
    private Short ativo = EnumConstantsMentorSimNao.SIM.getValue();

    @Id
    @Column(nullable=false, name="ID_CNAE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CNAE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="CODIGO", length=7)
    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    @Column(name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getCodigo(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="PERC_PRESUNCAO_CSLL", precision=15, scale=2)
    public Double getPercPresuncaoCSLL() {
        return this.percPresuncaoCSLL;
    }

    public void setPercPresuncaoCSLL(Double percPresuncaoCSLL) {
        this.percPresuncaoCSLL = percPresuncaoCSLL;
    }

    @Column(name="PERC_PRESUNCAO_IRPJ", precision=15, scale=2)
    public Double getPercPresuncaoIRPJ() {
        return this.percPresuncaoIRPJ;
    }

    public void setPercPresuncaoIRPJ(Double percPresuncaoIRPJ) {
        this.percPresuncaoIRPJ = percPresuncaoIRPJ;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DESMEMBRAMENTO", length=100)
    public String getDesmembramento() {
        return this.desmembramento;
    }

    public void setDesmembramento(String desmembramento) {
        this.desmembramento = desmembramento;
    }

    @Column(name="ALIQUOTA_CSLL", precision=15, scale=6)
    public Double getAliquotaCSLL() {
        return this.aliquotaCSLL;
    }

    public void setAliquotaCSLL(Double aliquotaCSLL) {
        this.aliquotaCSLL = aliquotaCSLL;
    }

    @Column(name="ALIQUOTA_IRPJ", precision=15, scale=6)
    public Double getAliquotaIRPJ() {
        return this.aliquotaIRPJ;
    }

    public void setAliquotaIRPJ(Double aliquotaIRPJ) {
        this.aliquotaIRPJ = aliquotaIRPJ;
    }

    @Column(nullable=false, name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }
}

