/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EsocCategoriaTrabalhador;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="CADASTRO_MULTIPLOS_VINCULOS")
public class CadastroMultiplosVinculos
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private String cnpj;
    private EsocCategoriaTrabalhador esocCategoria;
    private Double valorRemuneracaoRecebida = 0.0;
    private Short ativo = 1;
    private Colaborador colaborador;
    private String nome;

    @Id
    @Column(nullable=false, unique=true, name="ID_CADASTRO_MULTIPLOS_VINC")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CADASTRO_MULTIPLOS_VINC")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="CNPJ", length=21)
    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_CATEGORIA", foreignKey=@ForeignKey(name="FK_CATEGORIA_ESOC_MULTIPLOS_VIN"))
    public EsocCategoriaTrabalhador getEsocCategoria() {
        return this.esocCategoria;
    }

    public void setEsocCategoria(EsocCategoriaTrabalhador esocCategoria) {
        this.esocCategoria = esocCategoria;
    }

    @Column(name="VALOR_REMUNERACAO_RECEBIDA", precision=15, scale=2)
    public Double getValorRemuneracaoRecebida() {
        return this.valorRemuneracaoRecebida;
    }

    public void setValorRemuneracaoRecebida(Double valorRemuneracaoRecebida) {
        this.valorRemuneracaoRecebida = valorRemuneracaoRecebida;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_COLABORADOR_MULT_VINCULOS"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @Column(name="NOME", length=100)
    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

