/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ConvenioPlanoSaude;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.TipoPlanoCadastroPlano;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CADASTRO_PLANO_SAUDE")
public class CadastroPlanoSaude
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private String descricao;
    private ConvenioPlanoSaude convenio;
    private Empresa empresa;
    private TipoCalculoEvento eventoMensalidadeTitular;
    private TipoCalculoEvento eventoMensalidadeDependente;
    private List<TipoPlanoCadastroPlano> tipoPlano = new ArrayList<TipoPlanoCadastroPlano>();

    @Id
    @Column(nullable=false, unique=true, name="ID_CADASTRO_PLANO_SAUDE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CADASTRO_PLANO_SAUDE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONVENIO_PLANO", foreignKey=@ForeignKey(name="FK_CONVENIO_PLANO_SAUDE_CADASTR"))
    public ConvenioPlanoSaude getConvenio() {
        return this.convenio;
    }

    public void setConvenio(ConvenioPlanoSaude convenio) {
        this.convenio = convenio;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EMPRESA_CAD_PLANO_SAUDE"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EVENTO_MENSALIDADE_TITULAR", foreignKey=@ForeignKey(name="FK_EVT_MENS_TITULAR_PLAN"))
    public TipoCalculoEvento getEventoMensalidadeTitular() {
        return this.eventoMensalidadeTitular;
    }

    public void setEventoMensalidadeTitular(TipoCalculoEvento eventoMensalidadeTitular) {
        this.eventoMensalidadeTitular = eventoMensalidadeTitular;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EVT_MENSALIDADE_DEPENDENTE", foreignKey=@ForeignKey(name="FK_EVT_MENS_DEPENDENTE_PLANO"))
    public TipoCalculoEvento getEventoMensalidadeDependente() {
        return this.eventoMensalidadeDependente;
    }

    public void setEventoMensalidadeDependente(TipoCalculoEvento eventoMensalidadeDependente) {
        this.eventoMensalidadeDependente = eventoMensalidadeDependente;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="cadastroPlanoSaude", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<TipoPlanoCadastroPlano> getTipoPlano() {
        return this.tipoPlano;
    }

    public void setTipoPlano(List<TipoPlanoCadastroPlano> tipoPlano) {
        this.tipoPlano = tipoPlano;
    }
}

