/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemApuracaoVlrFgtsPeriodo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CADASTRO_PROCESSO_FGTS")
public class CadastroProcessoFgts
implements Serializable {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private String descricao;
    private Date periodoInicio;
    private Date periodoFinal;
    private Long qtdadeParcela = 0L;
    private Double vlrDebitoApurado = 0.0;
    private Double vlrDebitoInformado = 0.0;
    private Double vlrParcela = 0.0;
    private String numeroProcesso;
    private List<ItemApuracaoVlrFgtsPeriodo> itensPeriodo = new ArrayList<ItemApuracaoVlrFgtsPeriodo>();

    @Id
    @Column(nullable=false, unique=true, name="ID_CAD_PROCESSO_FGTS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CAD_PROCESSO_FGTS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CADASTRO_PROCESSO_FGTS_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="NUMERO_PROCESSO", length=100)
    public String getNumeroProcesso() {
        return this.numeroProcesso;
    }

    public void setNumeroProcesso(String numeroProcesso) {
        this.numeroProcesso = numeroProcesso;
    }

    @Column(name="PERIODO_INICIO")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoInicio() {
        return this.periodoInicio;
    }

    public void setPeriodoInicio(Date periodoInicio) {
        this.periodoInicio = periodoInicio;
    }

    @Column(name="PERIODO_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoFinal() {
        return this.periodoFinal;
    }

    public void setPeriodoFinal(Date periodoFinal) {
        this.periodoFinal = periodoFinal;
    }

    @Column(name="QTDADE_PARCELA", precision=15, scale=2)
    public Long getQtdadeParcela() {
        return this.qtdadeParcela;
    }

    public void setQtdadeParcela(Long qtdadeParcela) {
        this.qtdadeParcela = qtdadeParcela;
    }

    @Column(name="VLR_DEBITO_APURADO", precision=15, scale=2)
    public Double getVlrDebitoApurado() {
        return this.vlrDebitoApurado;
    }

    public void setVlrDebitoApurado(Double vlrDebitoApurado) {
        this.vlrDebitoApurado = vlrDebitoApurado;
    }

    @Column(name="VLR_DEBITO_INFORMADO", precision=15, scale=2)
    public Double getVlrDebitoInformado() {
        return this.vlrDebitoInformado;
    }

    public void setVlrDebitoInformado(Double vlrDebitoInformado) {
        this.vlrDebitoInformado = vlrDebitoInformado;
    }

    @Column(name="VLR_PARCELA", precision=15, scale=2)
    public Double getVlrParcela() {
        return this.vlrParcela;
    }

    public void setVlrParcela(Double vlrParcela) {
        this.vlrParcela = vlrParcela;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="cadastroFgts", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemApuracaoVlrFgtsPeriodo> getItensPeriodo() {
        return this.itensPeriodo;
    }

    public void setItensPeriodo(List<ItemApuracaoVlrFgtsPeriodo> itensPeriodo) {
        this.itensPeriodo = itensPeriodo;
    }
}

