/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoAdesao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.CadastroEstabilidadesColaboradores;
import com.touchcomp.basementor.model.vo.CadastroReducaoSuspensaoContrato;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorSalario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="CADASTRO_REDUCAO_COLABORADOR")
public class CadastroReducaoColaborador
implements InterfaceVO {
    private Long identificador;
    private CadastroReducaoSuspensaoContrato cadastroReducao;
    private Double percentualReducao;
    private Colaborador colaborador;
    private Double ultimoSalario;
    private Double penultimoSalario;
    private Double antePenultimoSalario;
    private Short tipoAdesao;
    private String contaBancaria;
    private String digitoConta;
    private String agenciaBancaria;
    private String digitoAgencia;
    private String codigoBanco;
    private Short tipoConta;
    private ColaboradorSalario colaboradorSalario;
    private AfastamentoColaborador afastamentoColaborador;
    private CadastroEstabilidadesColaboradores estabilidade;
    private ColaboradorSalario colaboradorSalarioRetorno;
    private Date dataInicio;
    private Date dataFinal;
    private Long diasAdesao;
    private Long diasProrrogacao;

    public CadastroReducaoColaborador() {
        this.percentualReducao = 0.0;
        this.ultimoSalario = 0.0;
        this.penultimoSalario = 0.0;
        this.antePenultimoSalario = 0.0;
        this.tipoAdesao = EnumConstTipoAdesao.ADESAO_REDUCAO.getEnumId();
        this.tipoConta = 0;
        this.diasAdesao = 0L;
        this.diasProrrogacao = 0L;
    }

    public CadastroReducaoColaborador(Double percentualReducao, Colaborador colaborador) {
        this.percentualReducao = percentualReducao;
        this.colaborador = colaborador;
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_CAD_REDUCAO_COLABORADOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CAD_REDUCAO_COLABORADOR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CADASTRO_REDUCAO", foreignKey=@ForeignKey(name="FK_CADASTRO_REDUCAO_CO"))
    public CadastroReducaoSuspensaoContrato getCadastroReducao() {
        return this.cadastroReducao;
    }

    public void setCadastroReducao(CadastroReducaoSuspensaoContrato cadastroReducao) {
        this.cadastroReducao = cadastroReducao;
    }

    @Column(name="PERCENTUAL_REDUCAO", precision=15, scale=2)
    public Double getPercentualReducao() {
        return this.percentualReducao;
    }

    public void setPercentualReducao(Double percentualReducao) {
        this.percentualReducao = percentualReducao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_CADASTRO_REDUCAO_1"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="ULTIMO_SALARIO", precision=15, scale=2)
    public Double getUltimoSalario() {
        return this.ultimoSalario;
    }

    public void setUltimoSalario(Double ultimoSalario) {
        this.ultimoSalario = ultimoSalario;
    }

    @Column(name="PENULTIMO_SALARIO", precision=15, scale=2)
    public Double getPenultimoSalario() {
        return this.penultimoSalario;
    }

    public void setPenultimoSalario(Double penultimoSalario) {
        this.penultimoSalario = penultimoSalario;
    }

    @Column(name="ANTE_PENULTIMO_SALARIO", precision=15, scale=2)
    public Double getAntePenultimoSalario() {
        return this.antePenultimoSalario;
    }

    public void setAntePenultimoSalario(Double antePenultimoSalario) {
        this.antePenultimoSalario = antePenultimoSalario;
    }

    @Column(name="TIPO_ADESAO")
    public Short getTipoAdesao() {
        return this.tipoAdesao;
    }

    public void setTipoAdesao(Short tipoAdesao) {
        this.tipoAdesao = tipoAdesao;
    }

    @Column(name="CONTA_BANCARIA", length=10)
    public String getContaBancaria() {
        return this.contaBancaria;
    }

    public void setContaBancaria(String contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Column(name="DIGITO_CONTA", length=10)
    public String getDigitoConta() {
        return this.digitoConta;
    }

    public void setDigitoConta(String digitoConta) {
        this.digitoConta = digitoConta;
    }

    @Column(name="AGENCIA_BANCARIA", length=10)
    public String getAgenciaBancaria() {
        return this.agenciaBancaria;
    }

    public void setAgenciaBancaria(String agenciaBancaria) {
        this.agenciaBancaria = agenciaBancaria;
    }

    @Column(name="DIGITO_AGENCIA", length=10)
    public String getDigitoAgencia() {
        return this.digitoAgencia;
    }

    public void setDigitoAgencia(String digitoAgencia) {
        this.digitoAgencia = digitoAgencia;
    }

    @Column(name="CODIGO_BANCO", length=10)
    public String getCodigoBanco() {
        return this.codigoBanco;
    }

    public void setCodigoBanco(String codigoBanco) {
        this.codigoBanco = codigoBanco;
    }

    @Column(name="TIPO_CONTA")
    public Short getTipoConta() {
        return this.tipoConta;
    }

    public void setTipoConta(Short tipoConta) {
        this.tipoConta = tipoConta;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_COLABORADOR_SALARIO", foreignKey=@ForeignKey(name="FK_REDUCAO_SALARIO_COLABORADOR"))
    public ColaboradorSalario getColaboradorSalario() {
        return this.colaboradorSalario;
    }

    public void setColaboradorSalario(ColaboradorSalario colaboradorSalario) {
        this.colaboradorSalario = colaboradorSalario;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_AFASTAMENTO_COLABORADOR", foreignKey=@ForeignKey(name="FK_CADASTRO_REDLABORADOR_1"))
    public AfastamentoColaborador getAfastamentoColaborador() {
        return this.afastamentoColaborador;
    }

    public void setAfastamentoColaborador(AfastamentoColaborador afastamentoColaborador) {
        this.afastamentoColaborador = afastamentoColaborador;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_ESTABILIDADE", foreignKey=@ForeignKey(name="FK_CADASTRO_REDUCAO_COLADOR_1"))
    public CadastroEstabilidadesColaboradores getEstabilidade() {
        return this.estabilidade;
    }

    public void setEstabilidade(CadastroEstabilidadesColaboradores estabilidade) {
        this.estabilidade = estabilidade;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_COLABORADOR_SALARIO_RETORNO", foreignKey=@ForeignKey(name="FK_COLABORADOR_SALARIO_RET"))
    public ColaboradorSalario getColaboradorSalarioRetorno() {
        return this.colaboradorSalarioRetorno;
    }

    public void setColaboradorSalarioRetorno(ColaboradorSalario colaboradorSalarioRetorno) {
        this.colaboradorSalarioRetorno = colaboradorSalarioRetorno;
    }

    @Column(name="DATA_INICIO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dataInicio) {
        this.dataInicio = dataInicio;
    }

    @Column(name="DATA_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Column(name="DIAS_ADESAO")
    public Long getDiasAdesao() {
        return this.diasAdesao;
    }

    public void setDiasAdesao(Long diasAdesao) {
        this.diasAdesao = diasAdesao;
    }

    @Column(name="DIAS_PRORROGACAO", precision=15, scale=2)
    public Long getDiasProrrogacao() {
        return this.diasProrrogacao;
    }

    public void setDiasProrrogacao(Long diasProrrogacao) {
        this.diasProrrogacao = diasProrrogacao;
    }
}

