/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoAdesao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CadastroReducaoColaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.HorarioTrabalho;
import com.touchcomp.basementor.model.vo.TipoBeneficioEmergencial;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CADASTRO_RED_SUSPENSAO_CONTRATO")
public class CadastroReducaoSuspensaoContrato
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short tipoAdesao = EnumConstTipoAdesao.ADESAO_REDUCAO.getEnumId();
    private Date dataAcordo;
    private Date dataFinal;
    private Short buscarAtivos = 0;
    private List<CadastroReducaoColaborador> reducoes = new ArrayList<CadastroReducaoColaborador>();
    private Date dataInicioAdesao;
    private Long qtadeDias = 0L;
    private Short buscarContasBancarias = 0;
    private HorarioTrabalho horario;
    private TipoBeneficioEmergencial tipoBeneficio;

    @Id
    @Column(nullable=false, unique=true, name="ID_CAD_RED_SUSPENSAO_CONT")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CAD_RED_SUSPENSAO_CONT")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CADASTRO_RED_SUSPENSAO_CONTR"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="TIPO_ADESAO")
    public Short getTipoAdesao() {
        return this.tipoAdesao;
    }

    public void setTipoAdesao(Short tipoAdesao) {
        this.tipoAdesao = tipoAdesao;
    }

    @Column(name="DATA_ACORDO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataAcordo() {
        return this.dataAcordo;
    }

    public void setDataAcordo(Date dataAcordo) {
        this.dataAcordo = dataAcordo;
    }

    @Column(name="BUSCAR_ATIVOS")
    public Short getBuscarAtivos() {
        return this.buscarAtivos;
    }

    public void setBuscarAtivos(Short buscarAtivos) {
        this.buscarAtivos = buscarAtivos;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="cadastroReducao", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<CadastroReducaoColaborador> getReducoes() {
        return this.reducoes;
    }

    public void setReducoes(List<CadastroReducaoColaborador> reducoes) {
        this.reducoes = reducoes;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="DATA_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Column(name="DATA_INICIO_ADESAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicioAdesao() {
        return this.dataInicioAdesao;
    }

    public void setDataInicioAdesao(Date dataInicioAdesao) {
        this.dataInicioAdesao = dataInicioAdesao;
    }

    @Column(name="QTDADE_DIAS")
    public Long getQtadeDias() {
        return this.qtadeDias;
    }

    public void setQtadeDias(Long qtadeDias) {
        this.qtadeDias = qtadeDias;
    }

    @Column(name="BUSCAR_CONTAS_BANCARIAS")
    public Short getBuscarContasBancarias() {
        return this.buscarContasBancarias;
    }

    public void setBuscarContasBancarias(Short buscarContasBancarias) {
        this.buscarContasBancarias = buscarContasBancarias;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_HORARIO", foreignKey=@ForeignKey(name="FK_CADASTRO_RED_SUSP"))
    public HorarioTrabalho getHorario() {
        return this.horario;
    }

    public void setHorario(HorarioTrabalho horario) {
        this.horario = horario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_BENEFICIO", foreignKey=@ForeignKey(name="FK_CADASTRO_RED__CONTRATO_1"))
    public TipoBeneficioEmergencial getTipoBeneficio() {
        return this.tipoBeneficio;
    }

    public void setTipoBeneficio(TipoBeneficioEmergencial tipoBeneficio) {
        this.tipoBeneficio = tipoBeneficio;
    }
}

