/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ConstantsCalcFrete;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.TabelaCalculoFrete;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="CALCULO_FRETE")
public class CalculoFrete
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private List<Transportador> transportadores = new ArrayList<Transportador>();
    private List<TabelaCalculoFrete> tabelaCalculoFrete = new ArrayList<TabelaCalculoFrete>();
    private List<ConstantsCalcFrete> constantsCalcFrete = new ArrayList<ConstantsCalcFrete>();

    @Id
    @Column(name="ID_CALCULO_FRETE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CALCULO_FRETE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CALCULO_FRETE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(targetEntity=Transportador.class, fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.SAVE_UPDATE})
    @JoinTable(name="calculo_frete_transportadores", joinColumns={@JoinColumn(name="ID_calculo_frete")}, inverseJoinColumns={@JoinColumn(name="id_transportador")})
    public List<Transportador> getTransportadores() {
        return this.transportadores;
    }

    public void setTransportadores(List<Transportador> transportadores) {
        this.transportadores = transportadores;
    }

    @OneToMany(mappedBy="calculoFrete", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN, CascadeType.MERGE, CascadeType.PERSIST})
    public List<TabelaCalculoFrete> getTabelaCalculoFrete() {
        return this.tabelaCalculoFrete;
    }

    public void setTabelaCalculoFrete(List<TabelaCalculoFrete> subTabelaFrete) {
        this.tabelaCalculoFrete = subTabelaFrete;
    }

    @OneToMany(mappedBy="calculoFrete", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ConstantsCalcFrete> getConstantsCalcFrete() {
        return this.constantsCalcFrete;
    }

    public void setConstantsCalcFrete(List<ConstantsCalcFrete> constantsCalcFrete) {
        this.constantsCalcFrete = constantsCalcFrete;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

