/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemCartaCorrecao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CARTA_CORRECAO")
public class CartaCorrecao
implements InterfaceVO {
    private Long identificador;
    private Pessoa pessoa;
    private Date dataEmissao;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private Empresa empresa;
    private List<ItemCartaCorrecao> itemCorrecao = new ArrayList<ItemCartaCorrecao>();
    private Short tipoNota = 0;
    private NotaFiscalPropria notaFiscalPropria;

    @Id
    @Column(name="ID_CARTA_CORRECAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CARTA_CORRECAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_CARTA_CORRECAO_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CARTA_CORRECAO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPessoa()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="cartaCorrecao", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemCartaCorrecao> getItemCorrecao() {
        return this.itemCorrecao;
    }

    public void setItemCorrecao(List<ItemCartaCorrecao> itemCorrecao) {
        this.itemCorrecao = itemCorrecao;
    }

    @Column(nullable=false, name="TIPO_NOTA")
    public Short getTipoNota() {
        return this.tipoNota;
    }

    public void setTipoNota(Short tipoNota) {
        this.tipoNota = tipoNota;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_NOTA_FISCAL_PROPRIA", foreignKey=@ForeignKey(name="FK_CARTA_CORRECAO_NP"))
    public NotaFiscalPropria getNotaFiscalPropria() {
        return this.notaFiscalPropria;
    }

    public void setNotaFiscalPropria(NotaFiscalPropria notaFiscalPropria) {
        this.notaFiscalPropria = notaFiscalPropria;
    }
}

