/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CelulaProdCentroEstoque;
import com.touchcomp.basementor.model.vo.CelulaProdutivaEquipamento;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CELULA_PRODUTIVA", uniqueConstraints={@UniqueConstraint(name="UNQ1_CELULA_PRODUTIVA_DESCRICAO", columnNames={"DESCRICAO"})})
public class CelulaProdutiva
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private CentroCusto centroCusto;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private List<CelulaProdutivaEquipamento> equipamentos = new ArrayList<CelulaProdutivaEquipamento>();
    private Double valorCustoHora = 0.0;
    private Short ativo = 1;
    private List<CelulaProdCentroEstoque> centroEstoque = new ArrayList<CelulaProdCentroEstoque>();

    @Id
    @Column(nullable=false, name="ID_CELULA_PRODUTIVA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CELULA_PRODUTIVA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_CELULA_PRODUTIVA_C_CUSTO"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CELULA_PRODUTIVA_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=false, name="VALOR_CUSTO_HORA", precision=15, scale=4)
    public Double getValorCustoHora() {
        return this.valorCustoHora;
    }

    public void setValorCustoHora(Double valorCustoHora) {
        this.valorCustoHora = valorCustoHora;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @OneToMany(mappedBy="celulaProdutiva")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<CelulaProdCentroEstoque> getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(List<CelulaProdCentroEstoque> centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @OneToMany(mappedBy="celulaProdutiva", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<CelulaProdutivaEquipamento> getEquipamentos() {
        return this.equipamentos;
    }

    public void setEquipamentos(List<CelulaProdutivaEquipamento> equipamentos) {
        this.equipamentos = equipamentos;
    }
}

