/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstPadraoOutros;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoUsuarioCentroEstoque;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.WmsCadastroEndereco;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="CENTRO_ESTOQUE", uniqueConstraints={@UniqueConstraint(name="UNQ1_CENTRO_ESTOQUE", columnNames={"DESCRICAO"})})
public class CentroEstoque
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private String descricao;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short tipoCentroEstoque = EnumConstCentroEstPadraoOutros.TIPO_CENTRO_ESTOQUE_OUTROS.getValue();
    private Short tipoEstProprioTerceiros = EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue();
    private Pessoa parceiro;
    private Short tipoDisponibilidade = EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_NAO_DISPONIVEL.getValue();
    private Double capacidadePeso = 0.0;
    private Double capacidadeVolume = 0.0;
    private Short permitirEstoqueNegativo = 0;
    private Usuario usuarioAlteracao;
    private String codigoSincronizacao;
    private Short ativo = 1;
    private WmsCadastroEndereco wmsCadastroEndereco;
    private List<GrupoUsuarioCentroEstoque> usuarios = new ArrayList<GrupoUsuarioCentroEstoque>();

    @Id
    @Column(nullable=false, name="ID_CENTRO_ESTOQUE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CENTRO_ESTOQUE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CENTRO_ESTOQUE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(nullable=false, unique=true, name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="TIPO_CENTRO_ESTOQUE")
    public Short getTipoCentroEstoque() {
        return this.tipoCentroEstoque;
    }

    public void setTipoCentroEstoque(Short tipoCentroEstoque) {
        this.tipoCentroEstoque = tipoCentroEstoque;
    }

    @Column(updatable=false, name="TIPO_EST_PROPRIO_TERCEIROS")
    public Short getTipoEstProprioTerceiros() {
        return this.tipoEstProprioTerceiros;
    }

    public void setTipoEstProprioTerceiros(Short tipoEstProprioTerceiros) {
        this.tipoEstProprioTerceiros = tipoEstProprioTerceiros;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PARCEIRO", foreignKey=@ForeignKey(name="FK_CENTRO_ESTOQUE_PARCEIRO"))
    public Pessoa getParceiro() {
        return this.parceiro;
    }

    public void setParceiro(Pessoa parceiro) {
        this.parceiro = parceiro;
    }

    @Column(name="TIPO_DISPONIBILIDADE")
    public Short getTipoDisponibilidade() {
        return this.tipoDisponibilidade;
    }

    public void setTipoDisponibilidade(Short tipoDisponibilidade) {
        this.tipoDisponibilidade = tipoDisponibilidade;
    }

    @Column(nullable=false, name="CAPACIDADE_PESO", precision=15, scale=6)
    public Double getCapacidadePeso() {
        return this.capacidadePeso;
    }

    public void setCapacidadePeso(Double capacidadePeso) {
        this.capacidadePeso = capacidadePeso;
    }

    @Column(nullable=false, name="CAPACIDADE_VOLUME", precision=15, scale=6)
    public Double getCapacidadeVolume() {
        return this.capacidadeVolume;
    }

    public void setCapacidadeVolume(Double capacidadeVolume) {
        this.capacidadeVolume = capacidadeVolume;
    }

    @Column(name="PERMITIR_ESTOQUE_NEGATIVO")
    public Short getPermitirEstoqueNegativo() {
        return this.permitirEstoqueNegativo;
    }

    public void setPermitirEstoqueNegativo(Short permitirEstoqueNegativo) {
        this.permitirEstoqueNegativo = permitirEstoqueNegativo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_ALTERACAO", foreignKey=@ForeignKey(name="FK_CENTRO_ESTOQUE_USUARIO"))
    public Usuario getUsuarioAlteracao() {
        return this.usuarioAlteracao;
    }

    public void setUsuarioAlteracao(Usuario usuarioAlteracao) {
        this.usuarioAlteracao = usuarioAlteracao;
    }

    @Column(name="CODIGO_SINCRONIZACAO", length=25)
    public String getCodigoSincronizacao() {
        return this.codigoSincronizacao;
    }

    public void setCodigoSincronizacao(String codigoSincronizacao) {
        this.codigoSincronizacao = codigoSincronizacao;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @OneToMany(mappedBy="centroEstoque", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<GrupoUsuarioCentroEstoque> getUsuarios() {
        return this.usuarios;
    }

    public void setUsuarios(List<GrupoUsuarioCentroEstoque> usuarios) {
        this.usuarios = usuarios;
    }

    @OneToOne(mappedBy="centroEstoque")
    public WmsCadastroEndereco getWmsCadastroEndereco() {
        return this.wmsCadastroEndereco;
    }

    public void setWmsCadastroEndereco(WmsCadastroEndereco wmsCadastroEndereco) {
        this.wmsCadastroEndereco = wmsCadastroEndereco;
    }
}

