/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CheckInOutVisita;
import com.touchcomp.basementor.model.vo.CheckListAssinatura;
import com.touchcomp.basementor.model.vo.CheckListItem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloCheckList;
import com.touchcomp.basementor.model.vo.OrigemCheckList;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CHECK_LIST")
public class CheckList
implements InterfaceVO {
    private Long identificador;
    private ModeloCheckList modeloCheckList;
    private OrigemCheckList origemCheckList;
    private CheckInOutVisita checkInOutVisita;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private List<CheckListItem> itensCheckList = new ArrayList<CheckListItem>();
    private List<CheckListAssinatura> checkListAssinaturas = new ArrayList<CheckListAssinatura>();
    private String observacao;
    private Empresa empresa;
    private Date dataHoraCheckList;
    private Usuario usuario;
    private BigInteger idMobile;
    private List<RelacionamentoPessoa> relacionamentosGerados = new ArrayList<RelacionamentoPessoa>();

    @Id
    @Column(nullable=false, unique=true, name="ID_CHECK_LIST")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CHECK_LIST")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_MODELO_CHECK_LIST", foreignKey=@ForeignKey(name="FK_CHECK_LIST_MOD_CHECK_LIST"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ModeloCheckList getModeloCheckList() {
        return this.modeloCheckList;
    }

    public void setModeloCheckList(ModeloCheckList modeloCheckList) {
        this.modeloCheckList = modeloCheckList;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ORIGEM_CHECK_LIST", foreignKey=@ForeignKey(name="FK_CHECK_LIST_ORIG_CHECK_LIST"))
    public OrigemCheckList getOrigemCheckList() {
        return this.origemCheckList;
    }

    public void setOrigemCheckList(OrigemCheckList origemCheckList) {
        this.origemCheckList = origemCheckList;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(mappedBy="checkList")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<CheckListItem> getItensCheckList() {
        return this.itensCheckList;
    }

    public void setItensCheckList(List<CheckListItem> itensCheckList) {
        this.itensCheckList = itensCheckList;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getModeloCheckList() != null ? this.getModeloCheckList().getDescricao() : this.getModeloCheckList()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CHECK_INOUT_VISITA", foreignKey=@ForeignKey(name="FK_CHECK_LIST_CHECK_INOUT_VISIT"))
    public CheckInOutVisita getCheckInOutVisita() {
        return this.checkInOutVisita;
    }

    public void setCheckInOutVisita(CheckInOutVisita checkInOutVisita) {
        this.checkInOutVisita = checkInOutVisita;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CHECK_LIST_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_HORA_CHECK_LIST")
    public Date getDataHoraCheckList() {
        return this.dataHoraCheckList;
    }

    public void setDataHoraCheckList(Date dataHoraCheckList) {
        this.dataHoraCheckList = dataHoraCheckList;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_CHECK_LIST_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Ignore
    @Column(name="ID_MOBILE", precision=18, scale=0)
    public BigInteger getIdMobile() {
        return this.idMobile;
    }

    public void setIdMobile(BigInteger idMobile) {
        this.idMobile = idMobile;
    }

    @OneToMany(mappedBy="checkList")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<RelacionamentoPessoa> getRelacionamentosGerados() {
        return this.relacionamentosGerados;
    }

    public void setRelacionamentosGerados(List<RelacionamentoPessoa> relacionamentosGerados) {
        this.relacionamentosGerados = relacionamentosGerados;
    }

    @OneToMany(mappedBy="checkList", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<CheckListAssinatura> getCheckListAssinaturas() {
        return this.checkListAssinaturas;
    }

    public void setCheckListAssinaturas(List<CheckListAssinatura> checkListAssinaturas) {
        this.checkListAssinaturas = checkListAssinaturas;
    }
}

