/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.CompensacaoCheque;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CHEQUE", uniqueConstraints={@UniqueConstraint(name="UNQ1_CHEQUE", columnNames={"NUMERO", "ID_CONTA_VALOR"})})
public class Cheque
implements InterfaceVO {
    private Long identificador;
    private Integer numero = 0;
    private Date dataEmissao;
    private String favorecido;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Double valor = 0.0;
    private List<BaixaTitulo> baixaTitulo = new ArrayList<BaixaTitulo>();
    private ContaValores conta;
    private Date dataValidade;
    private CompensacaoCheque compensacaoCheque;
    private Short cancelado = 0;

    @Id
    @Column(name="ID_CHEQUE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CHEQUE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=true, name="NUMERO")
    public Integer getNumero() {
        return this.numero;
    }

    public void setNumero(Integer numero) {
        this.numero = numero;
    }

    @Column(nullable=false, name="DATA_EMISSAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Column(name="FAVORECIDO", length=120)
    public String getFavorecido() {
        return this.favorecido;
    }

    public void setFavorecido(String favorecido) {
        this.favorecido = favorecido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="EMPRESA", foreignKey=@ForeignKey(name="FK_CHEQUE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(mappedBy="cheque", fetch=FetchType.LAZY)
    public List<BaixaTitulo> getBaixaTitulo() {
        return this.baixaTitulo;
    }

    public void setBaixaTitulo(List<BaixaTitulo> baixaTitulo) {
        this.baixaTitulo = baixaTitulo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getFavorecido()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=true, name="VALOR", precision=12, scale=2)
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTA_VALOR", foreignKey=@ForeignKey(name="FK_CHEQUE_CONTA_VALORES"))
    public ContaValores getConta() {
        return this.conta;
    }

    public void setConta(ContaValores conta) {
        this.conta = conta;
    }

    @Column(name="DATA_VALIDADE")
    @Temporal(value=TemporalType.DATE)
    public Date getDataValidade() {
        return this.dataValidade;
    }

    public void setDataValidade(Date dataValidade) {
        this.dataValidade = dataValidade;
    }

    @OneToOne(mappedBy="cheque", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public CompensacaoCheque getCompensacaoCheque() {
        return this.compensacaoCheque;
    }

    public void setCompensacaoCheque(CompensacaoCheque compensacaoCheque) {
        this.compensacaoCheque = compensacaoCheque;
    }

    @Column(name="CANCELADO")
    public Short getCancelado() {
        return this.cancelado;
    }

    public void setCancelado(Short cancelado) {
        this.cancelado = cancelado;
    }
}

