/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.GrupoCidadesCidade;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="CIDADE")
public class Cidade
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private String cep;
    private UnidadeFederativa uf;
    private String codIbge;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private String codSiaf;
    private String codIbgeCompleto;
    private List<GrupoCidadesCidade> grupoCidades = new ArrayList<GrupoCidadesCidade>();

    @Id
    @Column(nullable=false, name="ID_CIDADE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CIDADE")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(unique=true, name="COD_IBGE", length=5)
    public String getCodIbge() {
        return this.codIbge;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Column(nullable=false, name="DESCRICAO", length=60)
    public String getDescricao() {
        return this.descricao;
    }

    @Column(unique=true, name="CEP", length=8)
    public String getCep() {
        return this.cep;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_UF", foreignKey=@ForeignKey(name="FK_CIDADE_UF"))
    public UnidadeFederativa getUf() {
        return this.uf;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setCodIbge(String codIbge) {
        this.codIbge = codIbge;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public void setUf(UnidadeFederativa uf) {
        this.uf = uf;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="COD_SIAF", length=4)
    public String getCodSiaf() {
        return this.codSiaf;
    }

    public void setCodSiaf(String codSiaf) {
        this.codSiaf = codSiaf;
    }

    @Column(name="COD_IBGE_COMPLETO", length=7)
    public String getCodIbgeCompleto() {
        return this.codIbgeCompleto;
    }

    public void setCodIbgeCompleto(String codIbgeCompleto) {
        this.codIbgeCompleto = codIbgeCompleto;
    }

    @OneToMany(mappedBy="cidade")
    public List<GrupoCidadesCidade> getGrupoCidades() {
        return this.grupoCidades;
    }

    public void setGrupoCidades(List<GrupoCidadesCidade> grupoCidades) {
        this.grupoCidades = grupoCidades;
    }
}

