/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceObjetos;
import com.touchcomp.basementor.model.vo.CheckNodeBI;
import com.touchcomp.basementor.model.vo.OrderNodeBI;
import com.touchcomp.basementor.model.vo.WhereNodeBI;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.IndexColumn;

@Entity
@Table(name="CLASSE_MODELO_BI")
public class ClasseModeloBI
implements InterfaceVO {
    private Long identificador;
    private String classe;
    private String descricao;
    private BusinessIntelligenceObjetos businessIntelligenceObjetos;
    private List<CheckNodeBI> nodosSelecao;
    private List<WhereNodeBI> nodosCondicao = new ArrayList<WhereNodeBI>();
    private List<OrderNodeBI> nodosOrdenacao;

    public ClasseModeloBI() {
        this.nodosSelecao = new ArrayList<CheckNodeBI>();
        this.nodosOrdenacao = new ArrayList<OrderNodeBI>();
    }

    @Id
    @Column(name="ID_CLASSE_MODELO_BI")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CLASSE_MODELO_BI")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @OneToMany(mappedBy="classeModelo", cascade={CascadeType.ALL}, orphanRemoval=true)
    @IndexColumn(name="indice")
    public List<CheckNodeBI> getNodosSelecao() {
        return this.nodosSelecao;
    }

    public void setNodosSelecao(List<CheckNodeBI> nodosSelecao) {
        this.nodosSelecao = nodosSelecao;
    }

    @Column(name="CLASSE", length=2000)
    public String getClasse() {
        return this.classe;
    }

    public void setClasse(String classe) {
        this.classe = classe;
    }

    @Column(name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="classeModelo", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<WhereNodeBI> getNodosCondicao() {
        return this.nodosCondicao;
    }

    public void setNodosCondicao(List<WhereNodeBI> nodosCondicao) {
        this.nodosCondicao = nodosCondicao;
    }

    @OneToMany(mappedBy="classeModelo", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<OrderNodeBI> getNodosOrdenacao() {
        return this.nodosOrdenacao;
    }

    public void setNodosOrdenacao(List<OrderNodeBI> nodosOrdenacao) {
        this.nodosOrdenacao = nodosOrdenacao;
    }

    @OneToOne
    @JoinColumn(name="ID_BUSSINESS_INTEL_OBJ", foreignKey=@ForeignKey(name="FK_CLASSE_MODELO_BI_BUS_OBJ"))
    public BusinessIntelligenceObjetos getBusinessIntelligenceObjetos() {
        return this.businessIntelligenceObjetos;
    }

    public void setBusinessIntelligenceObjetos(BusinessIntelligenceObjetos businessIntelligenceObjetos) {
        this.businessIntelligenceObjetos = businessIntelligenceObjetos;
    }
}

