/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClienteContSistemas;
import com.touchcomp.basementor.model.vo.ClienteFinContSisTpBD;
import com.touchcomp.basementor.model.vo.ClienteFinancContSistUsuarios;
import com.touchcomp.basementor.model.vo.CustoMensal;
import com.touchcomp.basementor.model.vo.CustoOutrosServicos;
import com.touchcomp.basementor.model.vo.CustoReembolso;
import com.touchcomp.basementor.model.vo.ServicoRPS;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CLIENTE_FINAN_CONT_SISTEMAS", uniqueConstraints={@UniqueConstraint(name="UNQ1_CLIENTE_FINAN_CONT_SISTEMA", columnNames={"ID_CLIENTE_CONTATO_SISTEMAS"})})
public class ClienteFinancContSistemas
implements InterfaceVO {
    private Long identificador;
    private Timestamp dataAtualizacao;
    private ClienteContSistemas clienteContSistemas;
    private List<CustoMensal> custoMensal = new ArrayList<CustoMensal>();
    private List<CustoOutrosServicos> custoOutrosServicos = new ArrayList<CustoOutrosServicos>();
    private List<CustoReembolso> custoReembolso = new ArrayList<CustoReembolso>();
    private Short diaVencimento = 0;
    private Short separarReembolso = 0;
    private Double vlrAdicionalReembolso = 0.0;
    private String mensagemFixa;
    private ServicoRPS servicoRpsFatVenda;
    private ServicoRPS servicoRpsFatManut;
    private List<ClienteFinContSisTpBD> tiposBD;
    private String chaveAcesso;
    private Short ativo = 1;
    private Short faturarReembolsos = 0;
    private Double percAjusteImpostos = 0.0;
    private List<ClienteFinancContSistUsuarios> usuariosModulo = new ArrayList<ClienteFinancContSistUsuarios>();

    public ClienteFinancContSistemas() {
        this.tiposBD = new ArrayList<ClienteFinContSisTpBD>();
    }

    @Id
    @Column(name="ID_CLIENTE_FINAN_CONT_SISTEMAS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CLIENTE_FINAN_CONT_SISTEMAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_CLIENTE_CONTATO_SISTEMAS", foreignKey=@ForeignKey(name="FK_CLIENTE_FINAN_CONT_SISTEMAS_"))
    public ClienteContSistemas getClienteContSistemas() {
        return this.clienteContSistemas;
    }

    public void setClienteContSistemas(ClienteContSistemas clienteContSistemas) {
        this.clienteContSistemas = clienteContSistemas;
    }

    @OneToMany(mappedBy="clienteFinancContSistemas", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<CustoMensal> getCustoMensal() {
        return this.custoMensal;
    }

    public void setCustoMensal(List<CustoMensal> custoMensal) {
        this.custoMensal = custoMensal;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getClienteContSistemas() != null ? this.getClienteContSistemas().getTomadorPrestadorRps().getPessoa() : this.getClienteContSistemas()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="clienteFinancContSistemas", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<CustoOutrosServicos> getCustoOutrosServicos() {
        return this.custoOutrosServicos;
    }

    public void setCustoOutrosServicos(List<CustoOutrosServicos> custoOutrosServicos) {
        this.custoOutrosServicos = custoOutrosServicos;
    }

    @OneToMany(mappedBy="clienteFinancContSistemas", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<CustoReembolso> getCustoReembolso() {
        return this.custoReembolso;
    }

    public void setCustoReembolso(List<CustoReembolso> custoReembolso) {
        this.custoReembolso = custoReembolso;
    }

    @Column(name="DIA_VENCIMENTO")
    public Short getDiaVencimento() {
        return this.diaVencimento;
    }

    public void setDiaVencimento(Short diaVencimento) {
        this.diaVencimento = diaVencimento;
    }

    @Column(name="SEPARAR_REEMBOLSO")
    public Short getSepararReembolso() {
        return this.separarReembolso;
    }

    public void setSepararReembolso(Short separarReembolso) {
        this.separarReembolso = separarReembolso;
    }

    @Column(nullable=false, name="VLR_ADICIONAL_REEMBOLSO", precision=15, scale=2)
    public Double getVlrAdicionalReembolso() {
        return this.vlrAdicionalReembolso;
    }

    public void setVlrAdicionalReembolso(Double vlrAdicionalReembolso) {
        this.vlrAdicionalReembolso = vlrAdicionalReembolso;
    }

    @Column(name="MENSAGEM_FIXA", length=500)
    public String getMensagemFixa() {
        return this.mensagemFixa;
    }

    public void setMensagemFixa(String mensagemFixa) {
        this.mensagemFixa = mensagemFixa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SERVICO_RPS_FAT_VENDA", foreignKey=@ForeignKey(name="FK_CLIENTE_FINAN_SERV_RPS_VENDA"))
    public ServicoRPS getServicoRpsFatVenda() {
        return this.servicoRpsFatVenda;
    }

    public void setServicoRpsFatVenda(ServicoRPS servicoRpsFatVenda) {
        this.servicoRpsFatVenda = servicoRpsFatVenda;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SERVICO_RPS_FAT_MANUT", foreignKey=@ForeignKey(name="FK_CLIENTE_FINAN_SERV_RPS_MANUT"))
    public ServicoRPS getServicoRpsFatManut() {
        return this.servicoRpsFatManut;
    }

    public void setServicoRpsFatManut(ServicoRPS servicoRpsFatManut) {
        this.servicoRpsFatManut = servicoRpsFatManut;
    }

    @OneToMany(mappedBy="clienteFinanceiroConSistemas")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ClienteFinContSisTpBD> getTiposBD() {
        return this.tiposBD;
    }

    public void setTiposBD(List<ClienteFinContSisTpBD> tiposBD) {
        this.tiposBD = tiposBD;
    }

    @Column(name="CHAVE_ACESSO", length=100)
    public String getChaveAcesso() {
        return this.chaveAcesso;
    }

    public void setChaveAcesso(String chaveAcesso) {
        this.chaveAcesso = chaveAcesso;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="FATURAR_REEMBOLSOS")
    public Short getFaturarReembolsos() {
        return this.faturarReembolsos;
    }

    public void setFaturarReembolsos(Short faturarReembolsos) {
        this.faturarReembolsos = faturarReembolsos;
    }

    @Column(name="PERC_AJUSTE_IMPOSTOS", precision=15, scale=2)
    public Double getPercAjusteImpostos() {
        return this.percAjusteImpostos;
    }

    public void setPercAjusteImpostos(Double percAjusteImpostos) {
        this.percAjusteImpostos = percAjusteImpostos;
    }

    @OneToMany(mappedBy="clienteFinancContSistemas", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ClienteFinancContSistUsuarios> getUsuariosModulo() {
        return this.usuariosModulo;
    }

    public void setUsuariosModulo(List<ClienteFinancContSistUsuarios> usuariosModulo) {
        this.usuariosModulo = usuariosModulo;
    }
}

