/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ColetaDadosAtivo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.TipoPontoControle;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="COLETA", uniqueConstraints={@UniqueConstraint(name="UNQ1_COLETA", columnNames={"ID_ATIVO", "NUMERO_COLETA", "ID_TIPO_PONTO_CONTROLE"}), @UniqueConstraint(name="UNQ2_COLETA_ANTERIOR", columnNames={"ID_COLETA_ANTERIOR"})})
public class Coleta
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataHoraColeta;
    private Long numeroColeta;
    private Integer valorColeta = 0;
    private Integer valorAcumulado = 0;
    private String descricao;
    private Equipamento ativo;
    private Coleta coletaAnterior;
    private Coleta coletaPosterior;
    private TipoPontoControle tipoPontoControle;
    private ColetaDadosAtivo coletaDadosAtivo;

    @Id
    @Column(nullable=false, name="ID_COLETA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_COLETA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_COLETA_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="DATA_HORA_COLETA")
    public Timestamp getDataHoraColeta() {
        return this.dataHoraColeta;
    }

    public void setDataHoraColeta(Timestamp dataHoraColeta) {
        this.dataHoraColeta = dataHoraColeta;
    }

    @Column(name="VALOR_COLETA", precision=15, scale=0)
    public Integer getValorColeta() {
        return this.valorColeta;
    }

    public void setValorColeta(Integer valorColeta) {
        this.valorColeta = valorColeta;
    }

    @Column(name="VALOR_ACUMULADO", precision=15, scale=0)
    public Integer getValorAcumulado() {
        return this.valorAcumulado;
    }

    public void setValorAcumulado(Integer valorAcumulado) {
        this.valorAcumulado = valorAcumulado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ATIVO", foreignKey=@ForeignKey(name="FK_COLETA_ATIVO"))
    public Equipamento getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Equipamento ativo) {
        this.ativo = ativo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLETA_ANTERIOR", foreignKey=@ForeignKey(name="FK_COLETA_COL_ANTERIOR"))
    public Coleta getColetaAnterior() {
        return this.coletaAnterior;
    }

    public void setColetaAnterior(Coleta coletaAnterior) {
        this.coletaAnterior = coletaAnterior;
    }

    @OneToOne(mappedBy="coletaAnterior", targetEntity=Coleta.class)
    public Coleta getColetaPosterior() {
        return this.coletaPosterior;
    }

    public void setColetaPosterior(Coleta coletaPosterior) {
        this.coletaPosterior = coletaPosterior;
    }

    @Ignore
    @Column(name="NUMERO_COLETA")
    public Long getNumeroColeta() {
        return this.numeroColeta;
    }

    public void setNumeroColeta(Long numeroColeta) {
        this.numeroColeta = numeroColeta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PONTO_CONTROLE", foreignKey=@ForeignKey(name="FK_COLETA_TP_CONTROLE"))
    public TipoPontoControle getTipoPontoControle() {
        return this.tipoPontoControle;
    }

    public void setTipoPontoControle(TipoPontoControle tipoPontoControle) {
        this.tipoPontoControle = tipoPontoControle;
    }

    @Column(name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLETA_DADOS_ATIVO")
    public ColetaDadosAtivo getColetaDadosAtivo() {
        return this.coletaDadosAtivo;
    }

    public void setColetaDadosAtivo(ColetaDadosAtivo coletaDadosAtivo) {
        this.coletaDadosAtivo = coletaDadosAtivo;
    }
}

