/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CNAE;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TelefonePessoa;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import com.touchcomp.basementortools.tools.vo.equals.IdProperty;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="COMPLEMENTO")
@IdProperty(name="idComp")
public class Complemento
implements InterfaceVO {
    private Long idComp;
    private String fone1 = "";
    private String fone2 = "";
    private String fax1 = "";
    private String fax2 = "";
    private String cel1 = "";
    private String cel2 = "";
    private String cnpj;
    private String inscEst;
    private String site = "";
    private Timestamp dataAtualizacao;
    private String inscricaoMunicipal;
    private String rg;
    private String orgaoEmissor;
    private Integer nit = 0;
    private String suframa;
    private String inscrEstadualST;
    private Date dataNascimento;
    private Date dataEmissaoRG;
    private Short habilitarSuframa = 0;
    private Date dataValidadeIMA;
    private String codigoIMA;
    private List<EmailPessoa> emails = new ArrayList<EmailPessoa>();
    private Short ativo = 1;
    private Pessoa pessoa;
    private String passaporte;
    private CNAE cnae;
    private Short contribuinteEstado = 0;
    private UnidadeFederativa ufEmissaoRG;
    private String emailPrincipal;
    private String registroIdentificacaoCivil = "";
    private String orgaoEmissorRic = "";
    private Date dataEmissaoRic;
    private String codCei = "";
    private Short tipoPessoa = EnumConstTipoPessoaComplementar.FISICA.getEnumId();
    private List<TelefonePessoa> outrosTelefones = new ArrayList<TelefonePessoa>();

    @Id
    @Column(nullable=false, name="ID_COMPLEMENTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_COMPLEMENTO")
    public Long getIdComp() {
        return this.idComp;
    }

    @Column(name="FONE1", length=14)
    public String getFone1() {
        return this.fone1;
    }

    @Column(name="FONE2", length=14)
    public String getFone2() {
        return this.fone2;
    }

    @Column(name="FAX1", length=14)
    public String getFax1() {
        return this.fax1;
    }

    @Column(name="FAX2", length=14)
    public String getFax2() {
        return this.fax2;
    }

    @Column(name="CEL1", length=14)
    public String getCel1() {
        return this.cel1;
    }

    @Column(name="CEL2", length=14)
    public String getCel2() {
        return this.cel2;
    }

    @Column(name="CNPJ", length=18)
    public String getCnpj() {
        return this.cnpj;
    }

    @Column(name="INSCRICAO_ESTADUAL", length=18)
    public String getInscEst() {
        return this.inscEst;
    }

    @Column(name="SITE", length=300)
    public String getSite() {
        return this.site;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Column(name="INSCRICAO_MUNICIPAL", length=18)
    public String getInscricaoMunicipal() {
        return this.inscricaoMunicipal;
    }

    @Column(name="NIT")
    public Integer getNit() {
        return this.nit;
    }

    @Column(name="SUFRAMA", length=18)
    public String getSuframa() {
        return this.suframa;
    }

    @Column(name="INSCRICAO_ESTADUAL_ST", length=18)
    public String getInscrEstadualST() {
        return this.inscrEstadualST;
    }

    @Column(name="DATA_NASCIMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(Date dataNascimento) {
        this.dataNascimento = dataNascimento;
    }

    public void setIdComp(Long idComp) {
        this.idComp = idComp;
    }

    public void setFone1(String fone1) {
        this.fone1 = fone1;
    }

    public void setFone2(String fone2) {
        this.fone2 = fone2;
    }

    public void setFax1(String fax1) {
        this.fax1 = fax1;
    }

    public void setFax2(String fax2) {
        this.fax2 = fax2;
    }

    public void setCel1(String cel1) {
        this.cel1 = cel1;
    }

    public void setCel2(String cel2) {
        this.cel2 = cel2;
    }

    public void setCnpj(String cgc) {
        this.cnpj = cgc;
    }

    public void setInscEst(String inscEst) {
        this.inscEst = inscEst;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setInscricaoMunicipal(String inscricaoMunicipal) {
        this.inscricaoMunicipal = inscricaoMunicipal;
    }

    public void setNit(Integer nit) {
        this.nit = nit;
    }

    public void setSuframa(String suframa) {
        this.suframa = suframa;
    }

    public void setInscrEstadualST(String inscrEstadualST) {
        this.inscrEstadualST = inscrEstadualST;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdComp()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdComp());
    }

    @Column(name="RG", length=15)
    public String getRg() {
        return this.rg;
    }

    public void setRg(String rg) {
        this.rg = rg;
    }

    @Column(name="ORGAO_EMISSOR", length=10)
    public String getOrgaoEmissor() {
        return this.orgaoEmissor;
    }

    public void setOrgaoEmissor(String orgaoEmissor) {
        this.orgaoEmissor = orgaoEmissor;
    }

    @Column(name="DATA_EMISSAO_RG")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissaoRG() {
        return this.dataEmissaoRG;
    }

    public void setDataEmissaoRG(Date dataEmissaoRG) {
        this.dataEmissaoRG = dataEmissaoRG;
    }

    @Column(name="HABILITAR_SUFRAMA")
    public Short getHabilitarSuframa() {
        return this.habilitarSuframa;
    }

    public void setHabilitarSuframa(Short habilitarSuframa) {
        this.habilitarSuframa = habilitarSuframa;
    }

    @Column(name="CODIGO_IMA", length=20)
    public String getCodigoIMA() {
        return this.codigoIMA;
    }

    public void setCodigoIMA(String codigoIMA) {
        this.codigoIMA = codigoIMA;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_VALIDADE_IMA")
    public Date getDataValidadeIMA() {
        return this.dataValidadeIMA;
    }

    public void setDataValidadeIMA(Date dataValidadeIMA) {
        this.dataValidadeIMA = dataValidadeIMA;
    }

    @OneToMany(mappedBy="complemento", fetch=FetchType.LAZY, orphanRemoval=true, cascade={CascadeType.ALL})
    public List<EmailPessoa> getEmails() {
        return this.emails;
    }

    public void setEmails(List<EmailPessoa> emails) {
        this.emails = emails;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @OneToOne(mappedBy="complemento", fetch=FetchType.LAZY, targetEntity=Pessoa.class)
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Column(name="PASSAPORTE", length=20)
    public String getPassaporte() {
        return this.passaporte;
    }

    public void setPassaporte(String passaporte) {
        this.passaporte = passaporte;
    }

    @JoinColumn(name="ID_CNAE", foreignKey=@ForeignKey(name="FK_COMPLEMENTO_CNAE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CNAE getCnae() {
        return this.cnae;
    }

    public void setCnae(CNAE cnae) {
        this.cnae = cnae;
    }

    @Column(name="CONTRIBUINTE_ESTADO")
    public Short getContribuinteEstado() {
        return this.contribuinteEstado;
    }

    public void setContribuinteEstado(Short contribuinteEstado) {
        this.contribuinteEstado = contribuinteEstado;
    }

    @JoinColumn(name="ID_UF_EMISSOR_RG", foreignKey=@ForeignKey(name="FK_COMPLEMENTO_UF_RG"))
    @ManyToOne(fetch=FetchType.LAZY)
    public UnidadeFederativa getUfEmissaoRG() {
        return this.ufEmissaoRG;
    }

    public void setUfEmissaoRG(UnidadeFederativa ufEmissaoRG) {
        this.ufEmissaoRG = ufEmissaoRG;
    }

    @Column(name="EMAIL_PRINCIPAL", length=300)
    public String getEmailPrincipal() {
        return this.emailPrincipal;
    }

    public void setEmailPrincipal(String emailPrincipal) {
        this.emailPrincipal = emailPrincipal;
    }

    @Column(name="REGISTRO_IDENTIFICACAO_CIVIL", length=100)
    public String getRegistroIdentificacaoCivil() {
        return this.registroIdentificacaoCivil;
    }

    public void setRegistroIdentificacaoCivil(String registroIdentificacaoCivil) {
        this.registroIdentificacaoCivil = registroIdentificacaoCivil;
    }

    @Column(name="ORGAO_EMISSOR_RIC", length=100)
    public String getOrgaoEmissorRic() {
        return this.orgaoEmissorRic;
    }

    public void setOrgaoEmissorRic(String orgaoEmissorRic) {
        this.orgaoEmissorRic = orgaoEmissorRic;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EMISSAO_RIC")
    public Date getDataEmissaoRic() {
        return this.dataEmissaoRic;
    }

    public void setDataEmissaoRic(Date dataEmissaoRic) {
        this.dataEmissaoRic = dataEmissaoRic;
    }

    @Column(name="COD_CEI", length=12)
    public String getCodCei() {
        return this.codCei;
    }

    public void setCodCei(String codCei) {
        this.codCei = codCei;
    }

    @Column(name="TIPO_PESSOA")
    public Short getTipoPessoa() {
        return this.tipoPessoa;
    }

    public void setTipoPessoa(Short tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    @OneToMany(mappedBy="complemento", orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    public List<TelefonePessoa> getOutrosTelefones() {
        return this.outrosTelefones;
    }

    public void setOutrosTelefones(List<TelefonePessoa> outrosTelefones) {
        this.outrosTelefones = outrosTelefones;
    }
}

