/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.formulacaoprodutos.EnumConstTipoRateioDesmProdConjunta;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoOsProducaoLinhaProd;
import com.touchcomp.basementor.model.vo.IntegComProdItemComunicadoProd;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.OrdemServicoProdSobEnc;
import com.touchcomp.basementor.model.vo.PreFaturamentoNF;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.TipoProducaoSped;
import com.touchcomp.basementor.model.vo.WmsEntradaEstoque;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="COMUNICADO_PRODUCAO")
public class ComunicadoProducao
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private Date dataEntradaSaida;
    private List<ItemComunicadoProducao> itemComunicadoProducao = new ArrayList<ItemComunicadoProducao>();
    private EventoOsProducaoLinhaProd eventoOsProducao;
    private String observacao;
    private Date dataFinal;
    private PreFaturamentoNF preFaturamentoNF;
    private TipoProducaoSped tipoProducaoSped;
    private Requisicao requisicao;
    private WmsEntradaEstoque wmsEntradaEstoque;
    private IntegComProdItemComunicadoProd integComProdItemComunicadoProd;
    private Double percDesmancheNaoConsid = 0.0;
    private Double valorDesmancheNaoConsid = 0.0;
    private Double valorTotalCustoCom = 0.0;
    private Double valorTotalCustoReqVinc = 0.0;
    private Double quantidadeProd = 0.0;
    private Double quantidadeRef = 0.0;
    private Short tipoRateioDesmProdConjunta = EnumConstTipoRateioDesmProdConjunta.PERCENTUAL_INFORMADO.getCodigo();
    private OrdemServicoProdSobEnc ordemServicoProdSobEnc;

    @Id
    @Column(name="ID_COMUNICADO_PRODUCAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_COMUNICADO_PRODUCAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_COMUNICADO_PRODUCAO_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ENTRADA_SAIDA")
    public Date getDataEntradaSaida() {
        return this.dataEntradaSaida;
    }

    @OneToMany(mappedBy="comunicadoProducao", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemComunicadoProducao> getItemComunicadoProducao() {
        return this.itemComunicadoProducao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EVENTO_OS_PROD_LINHA_PROD", foreignKey=@ForeignKey(name="FK_COMUNICADO_PROD_EVT_LIN_PR"))
    public EventoOsProducaoLinhaProd getEventoOsProducao() {
        return this.eventoOsProducao;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataEntradaSaida(Date dataEntradaSaida) {
        this.dataEntradaSaida = dataEntradaSaida;
    }

    public void setItemComunicadoProducao(List<ItemComunicadoProducao> itemImplantaSaldo) {
        this.itemComunicadoProducao = itemImplantaSaldo;
    }

    public void setEventoOsProducao(EventoOsProducaoLinhaProd eventoOsProducao) {
        this.eventoOsProducao = eventoOsProducao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}-{1}", (Object[])new Object[]{this.getIdentificador(), ToolDate.dateToStr((Date)this.dataEntradaSaida)});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="DATA_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRE_FATURAMENTO_NF", foreignKey=@ForeignKey(name="FK_COMUNICADO_PROD_PRE_FAT_NF"))
    public PreFaturamentoNF getPreFaturamentoNF() {
        return this.preFaturamentoNF;
    }

    public void setPreFaturamentoNF(PreFaturamentoNF preFaturamentoNF) {
        this.preFaturamentoNF = preFaturamentoNF;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PRODUCAO_SPED", foreignKey=@ForeignKey(name="FK_COM_PROD_TP_PROD_SPED"))
    public TipoProducaoSped getTipoProducaoSped() {
        return this.tipoProducaoSped;
    }

    public void setTipoProducaoSped(TipoProducaoSped tipoProducaoSped) {
        this.tipoProducaoSped = tipoProducaoSped;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, optional=true)
    @JoinColumn(name="ID_REQUISICAO", foreignKey=@ForeignKey(name="FK_COMUNICADO_PROD_REQUISICAO"))
    public Requisicao getRequisicao() {
        return this.requisicao;
    }

    public void setRequisicao(Requisicao requisicao) {
        this.requisicao = requisicao;
    }

    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="comunicadoProducao")
    public WmsEntradaEstoque getWmsEntradaEstoque() {
        return this.wmsEntradaEstoque;
    }

    public void setWmsEntradaEstoque(WmsEntradaEstoque wmsEntradaEstoque) {
        this.wmsEntradaEstoque = wmsEntradaEstoque;
    }

    @OneToOne(mappedBy="comunicadoProducao")
    @Fetch(value=FetchMode.JOIN)
    public IntegComProdItemComunicadoProd getIntegComProdItemComunicadoProd() {
        return this.integComProdItemComunicadoProd;
    }

    public void setIntegComProdItemComunicadoProd(IntegComProdItemComunicadoProd integComProdItemComunicadoProd) {
        this.integComProdItemComunicadoProd = integComProdItemComunicadoProd;
    }

    @Column(name="PERC_CUSTO_DESMANCHE_N_CONSID")
    public Double getPercDesmancheNaoConsid() {
        return this.percDesmancheNaoConsid;
    }

    public void setPercDesmancheNaoConsid(Double percDesmancheNaoConsid) {
        this.percDesmancheNaoConsid = percDesmancheNaoConsid;
    }

    @Column(name="VR_CUSTO_DESMANCHE_N_CONSID")
    public Double getValorDesmancheNaoConsid() {
        return this.valorDesmancheNaoConsid;
    }

    public void setValorDesmancheNaoConsid(Double valorDesmancheNaoConsid) {
        this.valorDesmancheNaoConsid = valorDesmancheNaoConsid;
    }

    @Column(name="VR_CUSTO_TOTAL_COM")
    public Double getValorTotalCustoCom() {
        return this.valorTotalCustoCom;
    }

    public void setValorTotalCustoCom(Double valorTotalCustoCom) {
        this.valorTotalCustoCom = valorTotalCustoCom;
    }

    @Column(name="VR_CUSTO_TOTAL_REQ_VINC")
    public Double getValorTotalCustoReqVinc() {
        return this.valorTotalCustoReqVinc;
    }

    public void setValorTotalCustoReqVinc(Double valorTotalCustoReqVinc) {
        this.valorTotalCustoReqVinc = valorTotalCustoReqVinc;
    }

    @Column(name="TIPO_RATEIO_DESM_PROD_CONJUNTA")
    public Short getTipoRateioDesmProdConjunta() {
        return this.tipoRateioDesmProdConjunta;
    }

    public void setTipoRateioDesmProdConjunta(Short tipoRateioDesmProdConjunta) {
        this.tipoRateioDesmProdConjunta = tipoRateioDesmProdConjunta;
    }

    @OneToOne(mappedBy="comunicadoProducao")
    public OrdemServicoProdSobEnc getOrdemServicoProdSobEnc() {
        return this.ordemServicoProdSobEnc;
    }

    public void setOrdemServicoProdSobEnc(OrdemServicoProdSobEnc ordemServicoProdSobEnc) {
        this.ordemServicoProdSobEnc = ordemServicoProdSobEnc;
    }

    @Column(name="QUANTIDADE_PROD")
    public Double getQuantidadeProd() {
        return this.quantidadeProd;
    }

    public void setQuantidadeProd(Double quantidadeProd) {
        this.quantidadeProd = quantidadeProd;
    }

    @Column(name="QUANTIDADE_REF")
    public Double getQuantidadeRef() {
        return this.quantidadeRef;
    }

    public void setQuantidadeRef(Double quantidadeRef) {
        this.quantidadeRef = quantidadeRef;
    }
}

