/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ConciliacaoBancariaDia;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CONC_BANCARIA")
public class ConciliacaoBancaria
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private ContaValores contaValores;
    private String caminhoArquivo;
    private List<ConciliacaoBancariaDia> conciliacaoBancariaDia = new ArrayList<ConciliacaoBancariaDia>();
    private Timestamp dataAtualizacao;
    private Date dataInicial;
    private Date dataFinal;
    private Short gerarBloqueioMovBancario = 0;
    private Short statusConciliacaoBancaria = EnumConstStatusObjeto.EM_PREENCHIMENTO.getEnumId();

    @Id
    @Column(nullable=false, name="ID_CONC_BANCARIA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONC_BANCARIA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CONC_BANCARIA_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_CONTA_VALORES", foreignKey=@ForeignKey(name="FK_CONC_BANCARIA_CONTA_VAL"))
    public ContaValores getContaValores() {
        return this.contaValores;
    }

    public void setContaValores(ContaValores contaValores) {
        this.contaValores = contaValores;
    }

    @Column(name="CAMINHO_ARQUIVO", length=500)
    public String getCaminhoArquivo() {
        return this.caminhoArquivo;
    }

    public void setCaminhoArquivo(String caminhoArquivo) {
        this.caminhoArquivo = caminhoArquivo;
    }

    @OneToMany(mappedBy="conciliacaoBancaria", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ConciliacaoBancariaDia> getConciliacaoBancariaDia() {
        return this.conciliacaoBancariaDia;
    }

    public void setConciliacaoBancariaDia(List<ConciliacaoBancariaDia> conciliacaoBancariaDia) {
        this.conciliacaoBancariaDia = conciliacaoBancariaDia;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Column(name="GERAR_BLOQUEIO_MOV_BANCARIO")
    public Short getGerarBloqueioMovBancario() {
        return this.gerarBloqueioMovBancario;
    }

    public void setGerarBloqueioMovBancario(Short gerarBloqueioMovBancario) {
        this.gerarBloqueioMovBancario = gerarBloqueioMovBancario;
    }

    @Column(name="STATUS_CONCILIACAO_BANCARIA")
    public Short getStatusConciliacaoBancaria() {
        return this.statusConciliacaoBancaria;
    }

    public void setStatusConciliacaoBancaria(Short statusConciliacaoBancaria) {
        this.statusConciliacaoBancaria = statusConciliacaoBancaria;
    }
}

