/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.ConstantsLiberacaoNFTerceiros;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemConfNFTerceiros;
import com.touchcomp.basementor.model.vo.LiberacaoNFTerceiros;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CONFERENCIA_NF_TERC")
public class ConferenciaNFTerceiros
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Usuario usuario;
    private Short liberarConferencia = 0;
    private String motivoLiberacao;
    private Short conferida = 0;
    private List<ItemConfNFTerceiros> itemConfNFTerceiros = new ArrayList<ItemConfNFTerceiros>();
    private LiberacaoNFTerceiros liberacaoNota;
    private String observacao;
    private Timestamp dataLiberacao;
    private Short status = ConstantsLiberacaoNFTerceiros.STATUS_TRAVADO;

    @Id
    @Column(nullable=false, name="ID_CONFERENCIA_NF_TERC")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONFERENCIA_NF_TERC")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_CONFERENCIA_NF_TERC_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Column(name="MOTIVO_LIBERACAO", length=500)
    public String getMotivoLiberacao() {
        return this.motivoLiberacao;
    }

    public void setMotivoLiberacao(String motivoLiberacao) {
        this.motivoLiberacao = motivoLiberacao;
    }

    @Column(name="NOTA_CONFERIDA")
    public Short getConferida() {
        return this.conferida;
    }

    public void setConferida(Short conferida) {
        this.conferida = conferida;
    }

    @OneToMany(mappedBy="conferenciaNFTerceiros", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemConfNFTerceiros> getItemConfNFTerceiros() {
        return this.itemConfNFTerceiros;
    }

    public void setItemConfNFTerceiros(List<ItemConfNFTerceiros> itemConfNFTerceiros) {
        this.itemConfNFTerceiros = itemConfNFTerceiros;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getDataLiberacao() != null ? ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getDataLiberacao(), this.getIdentificador()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToOne(fetch=FetchType.LAZY, mappedBy="liberacaoEstoque", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public LiberacaoNFTerceiros getLiberacaoNota() {
        return this.liberacaoNota;
    }

    public void setLiberacaoNota(LiberacaoNFTerceiros liberacaoNota) {
        this.liberacaoNota = liberacaoNota;
    }

    @Column(name="LIBERAR_CONFERENCIA")
    public Short getLiberarConferencia() {
        return this.liberarConferencia;
    }

    public void setLiberarConferencia(Short liberarConferencia) {
        this.liberarConferencia = liberarConferencia;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CONFERENCIA_NF_TERC_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_LIBERACAO")
    public Timestamp getDataLiberacao() {
        return this.dataLiberacao;
    }

    public void setDataLiberacao(Timestamp dataLiberacao) {
        this.dataLiberacao = dataLiberacao;
    }

    @Column(name="STATUS")
    public Short getStatus() {
        return this.status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }
}

