/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificadoEmp;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificadoItem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="CONFIGURACAO_CERTIFICADO")
public class ConfiguracaoCertificado
implements InterfaceVO {
    private Long identificador;
    private byte[] arquivoCFGToken;
    private byte[] arquivoJKS;
    private String descricao;
    private String senha;
    private byte[] arquivoPFX;
    private Short tipoCertificado = 5;
    private String aliasCertWindows;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Date dataCadastro;
    private List<ConfiguracaoCertificadoItem> itensConfCertificado = new ArrayList<ConfiguracaoCertificadoItem>();
    private Short tipoConfCadeiaCertificados = 1;
    private List<ConfiguracaoCertificadoEmp> empresas = new ArrayList<ConfiguracaoCertificadoEmp>();

    @Id
    @Column(nullable=false, name="ID_CONFIG_CERTIFICADO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONFIG_CERTIFICADO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="ARQUIVO_CFG_TOKEN")
    public byte[] getArquivoCFGToken() {
        return this.arquivoCFGToken;
    }

    public void setArquivoCFGToken(byte[] arquivoCFGToken) {
        this.arquivoCFGToken = arquivoCFGToken;
    }

    @Column(name="ARQUIVO_JKS")
    public byte[] getArquivoJKS() {
        return this.arquivoJKS;
    }

    public void setArquivoJKS(byte[] arquivoJKS) {
        this.arquivoJKS = arquivoJKS;
    }

    @Column(name="SENHA", length=20)
    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    @Column(name="ARQUIVO_PFX")
    public byte[] getArquivoPFX() {
        return this.arquivoPFX;
    }

    public void setArquivoPFX(byte[] arquivoPFX) {
        this.arquivoPFX = arquivoPFX;
    }

    @Column(name="TIPO_CERTIFICADO")
    public Short getTipoCertificado() {
        return this.tipoCertificado;
    }

    public void setTipoCertificado(Short tipoCertificado) {
        this.tipoCertificado = tipoCertificado;
    }

    @Column(name="ALIAS_CERT_WINDOWS", length=500)
    public String getAliasCertWindows() {
        return this.aliasCertWindows;
    }

    public void setAliasCertWindows(String aliasCertWindows) {
        this.aliasCertWindows = aliasCertWindows;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CONFIGURACAO_CERTIFICADO_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        Object ret = "";
        if (this.getTipoCertificado() != null) {
            if (this.getTipoCertificado() == 0) {
                ret = (String)ret + "Arquivo";
            } else if (this.getTipoCertificado() == 1) {
                ret = (String)ret + "Token";
            } else if (this.getTipoCertificado() == 2) {
                ret = (String)ret + "Repositario do Windows";
            } else if (this.getTipoCertificado() == 5) {
                ret = (String)ret + "Sem Certificado";
            }
        }
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{ret, this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="DESCRICAO", length=300)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @OneToMany(mappedBy="configuracaoCertificado")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ConfiguracaoCertificadoItem> getItensConfCertificado() {
        return this.itensConfCertificado;
    }

    public void setItensConfCertificado(List<ConfiguracaoCertificadoItem> itensConfCertificado) {
        this.itensConfCertificado = itensConfCertificado;
    }

    @Column(name="TIPO_CONF_CADEIA_CERTIFICADOS")
    public Short getTipoConfCadeiaCertificados() {
        return this.tipoConfCadeiaCertificados;
    }

    public void setTipoConfCadeiaCertificados(Short tipoConfCadeiaCertificados) {
        this.tipoConfCadeiaCertificados = tipoConfCadeiaCertificados;
    }

    @OneToMany(mappedBy="configuracaoCertificado", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ConfiguracaoCertificadoEmp> getEmpresas() {
        return this.empresas;
    }

    public void setEmpresas(List<ConfiguracaoCertificadoEmp> empresas) {
        this.empresas = empresas;
    }
}

