/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.ItemConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.TipoCnab;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="CONFIGURACAO_CNAB", uniqueConstraints={@UniqueConstraint(name="UNQ_LAYOUT_BANCO_TIPO", columnNames={"LAYOUT", "ID_INSTITUICAO_VALORES", "ID_TIPO_CNAB"})})
public class ConfiguracaoCnab
implements InterfaceVO {
    private Long identificador;
    private String layout;
    private Empresa empresa;
    private String descricao;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private InstituicaoValores instituicaoValores;
    private List<ItemConfiguracaoCnab> itensConfiguracaoCnab = new ArrayList<ItemConfiguracaoCnab>();
    private Short valorTarifa = 0;
    private Short valorIof = 0;
    private Short valorOutrosCreditos = 0;
    private Short valorAbatimento = 0;
    private Short valorDespesaBancaria = 0;
    private Short valorJuros = 0;
    private Short valorDesconto = 0;
    private Short valorMulta = 0;
    private TipoCnab tipoCnab;
    private Short tipoNumeroTitulo = 0;

    @Column(nullable=false, name="LAYOUT", length=6)
    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CONFIGURACAO_CNAB_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INSTITUICAO_VALORES", foreignKey=@ForeignKey(name="FK_CONFIGURACAO_CNAB_INST_VALOR"))
    public InstituicaoValores getInstituicaoValores() {
        return this.instituicaoValores;
    }

    public void setInstituicaoValores(InstituicaoValores instituicaoValores) {
        this.instituicaoValores = instituicaoValores;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="configuracaoCnab")
    @Cascade(value={CascadeType.DELETE, CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<ItemConfiguracaoCnab> getItensConfiguracaoCnab() {
        return this.itensConfiguracaoCnab;
    }

    public void setItensConfiguracaoCnab(List<ItemConfiguracaoCnab> itensConfiguracaoCnab) {
        this.itensConfiguracaoCnab = itensConfiguracaoCnab;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1} / {2}", (Object[])new Object[]{this.getDescricao(), this.getLayout(), this.getTipoCnab()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="VALOR_TARIFA")
    public Short getValorTarifa() {
        return this.valorTarifa;
    }

    public void setValorTarifa(Short valorTarifa) {
        this.valorTarifa = valorTarifa;
    }

    @Column(name="VALOR_IOF")
    public Short getValorIof() {
        return this.valorIof;
    }

    public void setValorIof(Short valorIof) {
        this.valorIof = valorIof;
    }

    @Column(name="VALOR_OUTROS_CREDITOS")
    public Short getValorOutrosCreditos() {
        return this.valorOutrosCreditos;
    }

    public void setValorOutrosCreditos(Short valorOutrosCreditos) {
        this.valorOutrosCreditos = valorOutrosCreditos;
    }

    @Column(name="VALOR_ABATIMENTO")
    public Short getValorAbatimento() {
        return this.valorAbatimento;
    }

    public void setValorAbatimento(Short valorAbatimento) {
        this.valorAbatimento = valorAbatimento;
    }

    @Column(name="VALOR_DESPESA_BANCARIA")
    public Short getValorDespesaBancaria() {
        return this.valorDespesaBancaria;
    }

    public void setValorDespesaBancaria(Short valorDespesaBancaria) {
        this.valorDespesaBancaria = valorDespesaBancaria;
    }

    @Column(name="VALOR_JUROS")
    public Short getValorJuros() {
        return this.valorJuros;
    }

    public void setValorJuros(Short valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Column(name="VALOR_DESCONTO")
    public Short getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(Short valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Column(name="VALOR_MULTA")
    public Short getValorMulta() {
        return this.valorMulta;
    }

    public void setValorMulta(Short valorMulta) {
        this.valorMulta = valorMulta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CNAB", foreignKey=@ForeignKey(name="FK_CONFIGURACAO_CNAB_TIPO_CNAB"))
    public TipoCnab getTipoCnab() {
        return this.tipoCnab;
    }

    public void setTipoCnab(TipoCnab tipoCnab) {
        this.tipoCnab = tipoCnab;
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_CONFIGURACAO_CNAB")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONFIGURACAO_CNAB")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="TIPO_NUMERO_TITULO")
    public Short getTipoNumeroTitulo() {
        return this.tipoNumeroTitulo;
    }

    public void setTipoNumeroTitulo(Short tipoNumeroTitulo) {
        this.tipoNumeroTitulo = tipoNumeroTitulo;
    }
}

