/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.ConstantsTipoConta;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClassificacaoContaBancaria;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="CONTA_SALARIO")
public class ContaSalarioColaborador
implements InterfaceVO {
    private Long identificador;
    private String agencia;
    private String dvAgencia;
    private String contaCorrente;
    private String dvContaCorrente;
    private String dac;
    private Short ativo = 1;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private InstituicaoValores instituicaoValor;
    private Pessoa pessoa;
    private String cnpj;
    private Short tipoConta = ConstantsTipoConta.CONTA_CORRENTE;
    private ClassificacaoContaBancaria classificacaoContaBancaria;
    private Short preferencial = 0;
    private String operacao;

    @Id
    @Column(name="ID_CONTA_SALARIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONTA_SALARIO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="AGENCIA", length=5)
    public String getAgencia() {
        return this.agencia;
    }

    public void setAgencia(String agencia) {
        this.agencia = agencia;
    }

    @Column(name="DV_AGENCIA", length=1)
    public String getDvAgencia() {
        return this.dvAgencia;
    }

    public void setDvAgencia(String dvAgencia) {
        this.dvAgencia = dvAgencia;
    }

    @Column(name="CONTA_CORRENTE", length=12)
    public String getContaCorrente() {
        return this.contaCorrente;
    }

    public void setContaCorrente(String contaCorrente) {
        this.contaCorrente = contaCorrente;
    }

    @Column(name="DV_CONTA_CORRENTE", length=2)
    public String getDvContaCorrente() {
        return this.dvContaCorrente;
    }

    public void setDvContaCorrente(String dvContaCorrente) {
        this.dvContaCorrente = dvContaCorrente;
    }

    @Column(name="DAC", length=1)
    public String getDac() {
        return this.dac;
    }

    public void setDac(String dac) {
        this.dac = dac;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getInstituicaoValor() != null && this.getContaCorrente() != null && this.getDvContaCorrente() != null ? ToolBaseMethodsVO.toString((String)"{0} {1} {2}", (Object[])new Object[]{this.getInstituicaoValor(), this.getContaCorrente(), this.getDvContaCorrente()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INSTITUICAO_VALOR", foreignKey=@ForeignKey(name="FK_CONTA_SALARIO_INST_VALORES"))
    public InstituicaoValores getInstituicaoValor() {
        return this.instituicaoValor;
    }

    public void setInstituicaoValor(InstituicaoValores instituicaoValor) {
        this.instituicaoValor = instituicaoValor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_CONTA_SALARIO_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Column(name="CNPJ", length=18)
    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    @Column(name="TIPO_CONTA")
    public Short getTipoConta() {
        return this.tipoConta;
    }

    public void setTipoConta(Short tipoConta) {
        this.tipoConta = tipoConta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_CONTA_BANCARIA", foreignKey=@ForeignKey(name="FK_CONTA_SAL_COLAB_CLASS"))
    public ClassificacaoContaBancaria getClassificacaoContaBancaria() {
        return this.classificacaoContaBancaria;
    }

    public void setClassificacaoContaBancaria(ClassificacaoContaBancaria classificacaoContaBancaria) {
        this.classificacaoContaBancaria = classificacaoContaBancaria;
    }

    @Column(name="PREFERENCIAL")
    public Short getPreferencial() {
        return this.preferencial;
    }

    public void setPreferencial(Short preferencial) {
        this.preferencial = preferencial;
    }

    @Column(name="OPERACAO", length=5)
    public String getOperacao() {
        return this.operacao;
    }

    public void setOperacao(String operacao) {
        this.operacao = operacao;
    }
}

