/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CONTRA_PART_MOVIMENTO_BANCARIO")
public class ContraPartMovimentoBancario
implements InterfaceVO {
    private static final long serialVersionUID = 1L;
    private Long identificador;
    private PlanoConta planoConta;
    private Short debCred = 0;
    private BorderoTitulos bordero;
    private Double valor = 0.0;
    private String historico;
    private HistoricoPadrao historicoPadrao;
    private Short buscaTitulos = 0;
    private PlanoContaGerencial planoContaGerencial;
    private LancamentoCtbGerencial lancamentoCtbGerencial;
    private Short contraPartidaGeradaModeloLancamentoBancario = 0;
    private MovimentoBancario movimentoBancario;

    @Id
    @Column(nullable=false, name="ID_CONTRA_PART_BC")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONTRA_PART_BC")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, name="DEB_CRED")
    public Short getDebCred() {
        return this.debCred;
    }

    @Column(name="HISTORICO", length=2000)
    public String getHistorico() {
        return this.historico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_HISTORICO_PADRAO", foreignKey=@ForeignKey(name="FK_CONTRA_PART_BC_HIST_PADRAO"))
    public HistoricoPadrao getHistoricoPadrao() {
        return this.historicoPadrao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_CONTRA_PART_BC_PC"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    @Column(nullable=false, name="VALOR", precision=12, scale=2)
    public Double getValor() {
        return this.valor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BORDERO", foreignKey=@ForeignKey(name="FK_CONTRA_PART_BC_BORDERO"))
    public BorderoTitulos getBordero() {
        return this.bordero;
    }

    @Column(nullable=false, name="BUSCA_TITULO")
    public Short getBuscaTitulos() {
        return this.buscaTitulos;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setDebCred(Short debCred) {
        this.debCred = debCred;
    }

    public void setHistorico(String historico) {
        this.historico = historico;
    }

    public void setHistoricoPadrao(HistoricoPadrao historicoPadrao) {
        this.historicoPadrao = historicoPadrao;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    public void setBordero(BorderoTitulos bordero) {
        this.bordero = bordero;
    }

    public void setBuscaTitulos(Short buscaTitulos) {
        this.buscaTitulos = buscaTitulos;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{"mentorcore.model.vo.ContraPartMovimentoBancario[id=" + this.getIdentificador() + "]"});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToOne(targetEntity=LancamentoCtbGerencial.class, optional=true, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="ID_LANCAMENTO_CTB_GERENCIAL", foreignKey=@ForeignKey(name="FK_CONTRA_PART_BC_LANC_CTB_GER"))
    public LancamentoCtbGerencial getLancamentoCtbGerencial() {
        return this.lancamentoCtbGerencial;
    }

    public void setLancamentoCtbGerencial(LancamentoCtbGerencial lancamentoCtbGerencial) {
        this.lancamentoCtbGerencial = lancamentoCtbGerencial;
    }

    @JoinColumn(name="ID_PLANO_CONTA_GERENCIAL", foreignKey=@ForeignKey(name="FK_CONTRA_PART_BC_PC_GER"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    @Column(name="CP_GERADA_MOD_LANC_FINANC")
    public Short getContraPartidaGeradaModeloLancamentoBancario() {
        return this.contraPartidaGeradaModeloLancamentoBancario;
    }

    public void setContraPartidaGeradaModeloLancamentoBancario(Short contraPartida) {
        this.contraPartidaGeradaModeloLancamentoBancario = contraPartida;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOVIMENTO_BANCARIO ", foreignKey=@ForeignKey(name="FK_CONTRA_PART_BC_MOV_BANC"))
    public MovimentoBancario getMovimentoBancario() {
        return this.movimentoBancario;
    }

    public void setMovimentoBancario(MovimentoBancario movimentoBancario) {
        this.movimentoBancario = movimentoBancario;
    }
}

