/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemControleEntregaNotaPropria;
import com.touchcomp.basementor.model.vo.NFCe;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CONTROLE_ENTREGA_NOTA_PROPIA")
public class ControleEntregaNotaPropria
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private NotaFiscalPropria notaFiscalPropria;
    private Usuario usuario;
    private List<ItemControleEntregaNotaPropria> itemControleEntregaNotaPropria = new ArrayList<ItemControleEntregaNotaPropria>();
    private Date dataEntrega;
    private String observacao;
    private NFCe nfce;
    private Short tipo = EnumConstantsMentorSimNao.NAO.getValue();
    private Pedido pedido;
    private Pessoa pessoa;
    private Date horaEntrega;
    private String serialForSinc;
    private String serialForSincPedido;

    public ControleEntregaNotaPropria() {
        this.dataEntrega = new Date();
        this.horaEntrega = new Date();
    }

    @Id
    @Column(name="ID_CONTROLE_ENTREGA_NOTA_PROP")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONTROLE_ENTREGA_NOTA_PROP")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CONTROLE_ENTREGA_NOTA_PROP1"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_PROPRIA", foreignKey=@ForeignKey(name="FK_CONTROLE_ENTREGA_NOTA_PROP2"))
    public NotaFiscalPropria getNotaFiscalPropria() {
        return this.notaFiscalPropria;
    }

    public void setNotaFiscalPropria(NotaFiscalPropria notaFiscalPropria) {
        this.notaFiscalPropria = notaFiscalPropria;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_CONTROLE_ENTREGA_NOTA_PROP3"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @OneToMany(mappedBy="controleEntregaNotaPropria", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemControleEntregaNotaPropria> getItemControleEntregaNotaPropria() {
        return this.itemControleEntregaNotaPropria;
    }

    public void setItemControleEntregaNotaPropria(List<ItemControleEntregaNotaPropria> itemControleEntregaNotaPropria) {
        this.itemControleEntregaNotaPropria = itemControleEntregaNotaPropria;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ENTREGA")
    public Date getDataEntrega() {
        return this.dataEntrega;
    }

    public void setDataEntrega(Date dataEntrega) {
        this.dataEntrega = dataEntrega;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NFCE", foreignKey=@ForeignKey(name="FK_CONTROLE_ENTREGA_NOTA_PROP4"))
    public NFCe getNfce() {
        return this.nfce;
    }

    public void setNfce(NFCe nfce) {
        this.nfce = nfce;
    }

    @Column(name="TIPO")
    public Short getTipo() {
        return this.tipo;
    }

    public void setTipo(Short tipo) {
        this.tipo = tipo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PEDIDO", foreignKey=@ForeignKey(name="FK_CONTROLE_ENTREGA_NOTA_PROP5"))
    public Pedido getPedido() {
        return this.pedido;
    }

    public void setPedido(Pedido pedido) {
        this.pedido = pedido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_CONTROLE_ENTREGA_NOTA_PROP6"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Temporal(value=TemporalType.TIME)
    @Column(name="HORA_ENTREGA")
    public Date getHoraEntrega() {
        return this.horaEntrega;
    }

    public void setHoraEntrega(Date horaEntrega) {
        this.horaEntrega = horaEntrega;
    }

    @Column(name="SERIAL_FOR_SINC", length=50)
    public String getSerialForSinc() {
        return this.serialForSinc;
    }

    public void setSerialForSinc(String serialForSinc) {
        this.serialForSinc = serialForSinc;
    }

    @Column(name="SERIAL_FOR_SINC_PEDIDO", length=50)
    public String getSerialForSincPedido() {
        return this.serialForSincPedido;
    }

    public void setSerialForSincPedido(String serialForSincPedido) {
        this.serialForSincPedido = serialForSincPedido;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

