/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ControleQualLinProdSubOS;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FaseProdutiva;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeFormulaProduto;
import com.touchcomp.basementor.model.vo.ItemTipoControleQual;
import com.touchcomp.basementor.model.vo.RoteiroProducao;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="CONTROLE_QUAL_LIN_PROD")
public class ControleQualLinProd
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Usuario usuario;
    private Double qtdVerificada = 0.0;
    private Double percVerificar = 0.0;
    private Double qtdTotalSubOS = 0.0;
    private Double qtdAVerificar = 0.0;
    private List<ControleQualLinProdSubOS> controleQualSubOS = new ArrayList<ControleQualLinProdSubOS>();
    private Short liberado = 0;
    private Short liberarManual = 0;
    private String justificativa;
    private GradeCor gradeCor;
    private Date dataVerificacao;
    private FaseProdutiva faseProdutiva;
    private List<ItemTipoControleQual> itemTipoControleQual = new ArrayList<ItemTipoControleQual>();
    private Empresa empresa;
    private RoteiroProducao roteiroProducao;
    private GradeFormulaProduto gradeFormulaProduto;

    @Id
    @Column(nullable=false, name="ID_CONTROLE_QUAL_LIN_PROD")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONTROLE_QUAL_LIN_PROD")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_CONTROLE_QUAL_LIN_PROD_USU"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Column(nullable=false, name="QTD_VERIFICADA", precision=15, scale=6)
    public Double getQtdVerificada() {
        return this.qtdVerificada;
    }

    public void setQtdVerificada(Double qtdVerificada) {
        this.qtdVerificada = qtdVerificada;
    }

    @Column(name="LIBERADO")
    public Short getLiberado() {
        return this.liberado;
    }

    public void setLiberado(Short liberarado) {
        this.liberado = liberarado;
    }

    @Column(name="LIBERAR_MANUAL")
    public Short getLiberarManual() {
        return this.liberarManual;
    }

    public void setLiberarManual(Short liberarManual) {
        this.liberarManual = liberarManual;
    }

    @Column(name="JUSTIFICATIVA", length=500)
    public String getJustificativa() {
        return this.justificativa;
    }

    public void setJustificativa(String justificativa) {
        this.justificativa = justificativa;
    }

    @OneToMany(mappedBy="controleQualLinProd")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ControleQualLinProdSubOS> getControleQualSubOS() {
        return this.controleQualSubOS;
    }

    public void setControleQualSubOS(List<ControleQualLinProdSubOS> controleQualSubOS) {
        this.controleQualSubOS = controleQualSubOS;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_CONTROLE_QUAL_LIN_PROD_GR_CO"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_VERIFICACAO")
    public Date getDataVerificacao() {
        return this.dataVerificacao;
    }

    public void setDataVerificacao(Date dataVerificacao) {
        this.dataVerificacao = dataVerificacao;
    }

    @OneToMany(mappedBy="contQualLinProd")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ItemTipoControleQual> getItemTipoControleQual() {
        return this.itemTipoControleQual;
    }

    public void setItemTipoControleQual(List<ItemTipoControleQual> itemTipoControleQual) {
        this.itemTipoControleQual = itemTipoControleQual;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CONTROLE_QUAL_LIN_PROD_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(nullable=false, name="PERC_VERIFICAR", precision=15, scale=6)
    public Double getPercVerificar() {
        return this.percVerificar;
    }

    public void setPercVerificar(Double percVerificar) {
        this.percVerificar = percVerificar;
    }

    @Column(nullable=false, name="QTD_TOTAL_SUBOS", precision=15, scale=6)
    public Double getQtdTotalSubOS() {
        return this.qtdTotalSubOS;
    }

    public void setQtdTotalSubOS(Double qtdTotalSubOS) {
        this.qtdTotalSubOS = qtdTotalSubOS;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDataVerificacao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=false, name="QTD_A_VERIFICAR", precision=15, scale=6)
    public Double getQtdAVerificar() {
        return this.qtdAVerificar;
    }

    public void setQtdAVerificar(Double qtdAVerificar) {
        this.qtdAVerificar = qtdAVerificar;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FASE_PRODUTIVA", foreignKey=@ForeignKey(name="FK_CONTROLE_QUAL_LIN_PROD_F_PRO"))
    public FaseProdutiva getFaseProdutiva() {
        return this.faseProdutiva;
    }

    public void setFaseProdutiva(FaseProdutiva faseProdutiva) {
        this.faseProdutiva = faseProdutiva;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ROTEIRO_PRODUCAO", foreignKey=@ForeignKey(name="FK_CONTROLE_QUAL_LIN_PROD_R_PRO"))
    public RoteiroProducao getRoteiroProducao() {
        return this.roteiroProducao;
    }

    public void setRoteiroProducao(RoteiroProducao roteiroProducao) {
        this.roteiroProducao = roteiroProducao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_FORMULA_PRODUTO", foreignKey=@ForeignKey(name="FK_CONTROLE_QUAL_LIN_PROD_GRF"))
    public GradeFormulaProduto getGradeFormulaProduto() {
        return this.gradeFormulaProduto;
    }

    public void setGradeFormulaProduto(GradeFormulaProduto gradeFormulaProduto) {
        this.gradeFormulaProduto = gradeFormulaProduto;
    }
}

