/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.ComunicadoProducao;
import com.touchcomp.basementor.model.vo.ConversaoProdutosItem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.TicketFiscalTerceiros;
import com.touchcomp.basementor.model.vo.TipoProducao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="CONVERSAO_PRODUTOS")
public class ConversaoProdutos
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private String descricao;
    private TipoProducao tipoProducao;
    private NaturezaRequisicao naturezaRequisicao;
    private ComunicadoProducao comunicadoProducaoGerado;
    private GradeCor gradeCorOrigem;
    private GradeCor gradeCorDestino;
    private Double quantidadeOrigemTotal = 0.0;
    private Double quantidadeDestinoTotal = 0.0;
    private Date dataMovimento;
    private CentroCusto centroCusto;
    private List<ConversaoProdutosItem> itensConversao = new LinkedList<ConversaoProdutosItem>();
    private TicketFiscalTerceiros ticketFiscalTerceiros;

    @Id
    @Column(name="ID_CONVERSAO_PRODUTOS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONVERSAO_PRODUTOS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CONV_PROD_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PRODUCAO", foreignKey=@ForeignKey(name="FK_CONV_PROD_TIPO_PRODUCAO"))
    public TipoProducao getTipoProducao() {
        return this.tipoProducao;
    }

    public void setTipoProducao(TipoProducao tipoProducao) {
        this.tipoProducao = tipoProducao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_REQUISICAO", foreignKey=@ForeignKey(name="FK_CONV_PROD_NAT_REQUISICAO"))
    public NaturezaRequisicao getNaturezaRequisicao() {
        return this.naturezaRequisicao;
    }

    public void setNaturezaRequisicao(NaturezaRequisicao naturezaRequisicao) {
        this.naturezaRequisicao = naturezaRequisicao;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, optional=true)
    @JoinColumn(name="ID_COMUNICADO_PRODUCAO_GERADO", foreignKey=@ForeignKey(name="FK_CONV_PROD_COM_PROD_GERADO"))
    public ComunicadoProducao getComunicadoProducaoGerado() {
        return this.comunicadoProducaoGerado;
    }

    public void setComunicadoProducaoGerado(ComunicadoProducao comunicadoProducaoGerado) {
        this.comunicadoProducaoGerado = comunicadoProducaoGerado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR_ORIGEM", foreignKey=@ForeignKey(name="FK_CONV_PROD_GC_ORIGEM"))
    public GradeCor getGradeCorOrigem() {
        return this.gradeCorOrigem;
    }

    public void setGradeCorOrigem(GradeCor gradeCorOrigem) {
        this.gradeCorOrigem = gradeCorOrigem;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR_DESTINO", foreignKey=@ForeignKey(name="FK_CONV_PROD_GC_DESTINO"))
    public GradeCor getGradeCorDestino() {
        return this.gradeCorDestino;
    }

    public void setGradeCorDestino(GradeCor gradeCorDestino) {
        this.gradeCorDestino = gradeCorDestino;
    }

    @Column(name="QUANTIDADE_ORIGEM_TOTAL", precision=15, scale=6)
    public Double getQuantidadeOrigemTotal() {
        return this.quantidadeOrigemTotal;
    }

    public void setQuantidadeOrigemTotal(Double quantidadeOrigemTotal) {
        this.quantidadeOrigemTotal = quantidadeOrigemTotal;
    }

    @Column(name="QUANTIDADE_DEST_TOTAL", precision=15, scale=6)
    public Double getQuantidadeDestinoTotal() {
        return this.quantidadeDestinoTotal;
    }

    public void setQuantidadeDestinoTotal(Double quantidadeDestinoTotal) {
        this.quantidadeDestinoTotal = quantidadeDestinoTotal;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_MOVIMENTO")
    public Date getDataMovimento() {
        return this.dataMovimento;
    }

    public void setDataMovimento(Date dataMovimento) {
        this.dataMovimento = dataMovimento;
    }

    @OneToMany(mappedBy="conversaoProdutos", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ConversaoProdutosItem> getItensConversao() {
        return this.itensConversao;
    }

    public void setItensConversao(List<ConversaoProdutosItem> itensConversao) {
        this.itensConversao = itensConversao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_CONV_PROD_CENTRO_CUSTO"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TICKET_FISCAL_TERCEIROS", foreignKey=@ForeignKey(name="FK_CONV_PROD_TICKET_TERCEIROS"))
    public TicketFiscalTerceiros getTicketFiscalTerceiros() {
        return this.ticketFiscalTerceiros;
    }

    public void setTicketFiscalTerceiros(TicketFiscalTerceiros ticketFiscalTerceiros) {
        this.ticketFiscalTerceiros = ticketFiscalTerceiros;
    }
}

