/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocIndicativoLocalIntermintente;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.ItemConvocacaoContIntermitente;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="CONVOCACAO_CONT_INTERMITENTE")
public class ConvocacaoContratoIntermitente
implements InterfaceVO,
InterfaceVOEsocial {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Colaborador colaborador;
    private Date dataInicio;
    private Date dataFinal;
    private Integer qtadeDias = 0;
    private Date dataPagamento;
    private String codConvocacao;
    private EsocIndicativoLocalIntermintente local;
    private Pessoa pessoa;
    private String observacao;
    private Double remuneracao = 0.0;
    private Short informarImpostoManual = 0;
    private Double totalProventos = 0.0;
    private Double totalDescontos = 0.0;
    private Double totalLiquido = 0.0;
    private Double baseCalculoIrrf = 0.0;
    private Double baseCalculoInss = 0.0;
    private Double baseCalculoIrrfDec = 0.0;
    private Double baseCalculoInssDec = 0.0;
    private Double aliquotaInss = 0.0;
    private Double aliquotaInssDec = 0.0;
    private Double aliquotaIrrf = 0.0;
    private Double aliquotaIrrfDec = 0.0;
    private Double valorIrrf = 0.0;
    private Double valorInss = 0.0;
    private Double valorInssDec = 0.0;
    private Double valorIrrfDec = 0.0;
    private Double dependentesIrrf = 0.0;
    private List<EsocPreEvento> preEventosEsocial = new ArrayList<EsocPreEvento>();
    private List<ItemConvocacaoContIntermitente> itens = new ArrayList<ItemConvocacaoContIntermitente>();
    private Double baseCalculoFgts = 0.0;
    private Double aliquotaFgts = 0.0;
    private Double valorFgts = 0.0;
    private Double diasTrabalhados = 0.0;
    private Double diasFolgas = 0.0;
    private Double diasFeriados = 0.0;
    private Double filhoSalarioFamilia = 0.0;
    private Short pagamentoAposConvocacao = 0;

    @Id
    @Column(nullable=false, unique=true, name="ID_CONV_CONT_INTERMITENTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONV_CONT_INTERMITENTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CONV_CONTRATO_INTER_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_CONV_CONTRATO_INTER_COL"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIO")
    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dataInicio) {
        this.dataInicio = dataInicio;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Column(name="QTADE_DIAS")
    public Integer getQtadeDias() {
        return this.qtadeDias;
    }

    public void setQtadeDias(Integer qtadeDias) {
        this.qtadeDias = qtadeDias;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_PAGAMENTO")
    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public void setDataPagamento(Date dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @Column(name="COD_CONVOCACAO", length=100)
    public String getCodConvocacao() {
        return this.codConvocacao;
    }

    public void setCodConvocacao(String codConvocacao) {
        this.codConvocacao = codConvocacao;
    }

    @JoinColumn(name="ID_LOCAL", foreignKey=@ForeignKey(name="FK_CONVOCACAO_CONT_INTER_LOCAL"))
    @ManyToOne(fetch=FetchType.LAZY)
    public EsocIndicativoLocalIntermintente getLocal() {
        return this.local;
    }

    public void setLocal(EsocIndicativoLocalIntermintente local) {
        this.local = local;
    }

    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_CONVOCACAO_CONT_INTER_PESSOA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="REMUNERACAO", precision=15, scale=2)
    public Double getRemuneracao() {
        return this.remuneracao;
    }

    public void setRemuneracao(Double remuneracao) {
        this.remuneracao = remuneracao;
    }

    @Column(name="INFORMAR_IMPOSTO_MANUAL")
    public Short getInformarImpostoManual() {
        return this.informarImpostoManual;
    }

    public void setInformarImpostoManual(Short informarImpostoManual) {
        this.informarImpostoManual = informarImpostoManual;
    }

    @Column(name="TOTAL_PROVENTOS", precision=15, scale=2)
    public Double getTotalProventos() {
        return this.totalProventos;
    }

    public void setTotalProventos(Double totalProventos) {
        this.totalProventos = totalProventos;
    }

    @Column(name="TOTAL_DESCONTOS", precision=15, scale=2)
    public Double getTotalDescontos() {
        return this.totalDescontos;
    }

    public void setTotalDescontos(Double totalDescontos) {
        this.totalDescontos = totalDescontos;
    }

    @Column(name="TOTAL_LIQUIDO", precision=15, scale=2)
    public Double getTotalLiquido() {
        return this.totalLiquido;
    }

    public void setTotalLiquido(Double totalLiquido) {
        this.totalLiquido = totalLiquido;
    }

    @Column(name="BASE_CALCULO_IRRF", precision=15, scale=2)
    public Double getBaseCalculoIrrf() {
        return this.baseCalculoIrrf;
    }

    public void setBaseCalculoIrrf(Double baseCalculoIrrf) {
        this.baseCalculoIrrf = baseCalculoIrrf;
    }

    @Column(name="BASE_CALCULO_INSS", precision=15, scale=2)
    public Double getBaseCalculoInss() {
        return this.baseCalculoInss;
    }

    public void setBaseCalculoInss(Double baseCalculoInss) {
        this.baseCalculoInss = baseCalculoInss;
    }

    @Column(name="BASE_CALCULO_IRRF_DEC", precision=15, scale=2)
    public Double getBaseCalculoIrrfDec() {
        return this.baseCalculoIrrfDec;
    }

    public void setBaseCalculoIrrfDec(Double baseCalculoIrrfDec) {
        this.baseCalculoIrrfDec = baseCalculoIrrfDec;
    }

    @Column(name="BASE_CALCULO_INSS_DEC", precision=15, scale=2)
    public Double getBaseCalculoInssDec() {
        return this.baseCalculoInssDec;
    }

    public void setBaseCalculoInssDec(Double baseCalculoInssDec) {
        this.baseCalculoInssDec = baseCalculoInssDec;
    }

    @Column(name="ALIQUOTA_INSS", precision=15, scale=2)
    public Double getAliquotaInss() {
        return this.aliquotaInss;
    }

    public void setAliquotaInss(Double aliquotaInss) {
        this.aliquotaInss = aliquotaInss;
    }

    @Column(name="ALIQUOTA_INSS_DEC", precision=15, scale=2)
    public Double getAliquotaInssDec() {
        return this.aliquotaInssDec;
    }

    public void setAliquotaInssDec(Double aliquotaInssDec) {
        this.aliquotaInssDec = aliquotaInssDec;
    }

    @Column(name="ALIQUOTA_IRRF", precision=15, scale=2)
    public Double getAliquotaIrrf() {
        return this.aliquotaIrrf;
    }

    public void setAliquotaIrrf(Double aliquotaIrrf) {
        this.aliquotaIrrf = aliquotaIrrf;
    }

    @Column(name="ALIQUOTA_IRRF_DEC", precision=15, scale=2)
    public Double getAliquotaIrrfDec() {
        return this.aliquotaIrrfDec;
    }

    public void setAliquotaIrrfDec(Double aliquotaIrrfDec) {
        this.aliquotaIrrfDec = aliquotaIrrfDec;
    }

    @Column(name="VALOR_IRRF", precision=15, scale=2)
    public Double getValorIrrf() {
        return this.valorIrrf;
    }

    public void setValorIrrf(Double valorIrrf) {
        this.valorIrrf = valorIrrf;
    }

    @Column(name="VALOR_INSS", precision=15, scale=2)
    public Double getValorInss() {
        return this.valorInss;
    }

    public void setValorInss(Double valorInss) {
        this.valorInss = valorInss;
    }

    @Column(name="VALOR_INSS_DEC", precision=15, scale=2)
    public Double getValorInssDec() {
        return this.valorInssDec;
    }

    public void setValorInssDec(Double valorInssDec) {
        this.valorInssDec = valorInssDec;
    }

    @Column(name="VALOR_IRRF_DEC", precision=15, scale=2)
    public Double getValorIrrfDec() {
        return this.valorIrrfDec;
    }

    public void setValorIrrfDec(Double valorIrrfDec) {
        this.valorIrrfDec = valorIrrfDec;
    }

    @Column(name="DEPENDENTES_IRRF", precision=15, scale=2)
    public Double getDependentesIrrf() {
        return this.dependentesIrrf;
    }

    public void setDependentesIrrf(Double dependentesIrrf) {
        this.dependentesIrrf = dependentesIrrf;
    }

    @Override
    @OneToMany(mappedBy="convocacao")
    public List<EsocPreEvento> getPreEventosEsocial() {
        return this.preEventosEsocial;
    }

    public void setPreEventosEsocial(List<EsocPreEvento> preEventosEsocial) {
        this.preEventosEsocial = preEventosEsocial;
    }

    @OneToMany(fetch=FetchType.EAGER, mappedBy="convocacao", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    public List<ItemConvocacaoContIntermitente> getItens() {
        return this.itens;
    }

    public void setItens(List<ItemConvocacaoContIntermitente> itens) {
        this.itens = itens;
    }

    @Column(name="BASE_CALCULO_FGTS", precision=15, scale=2)
    public Double getBaseCalculoFgts() {
        return this.baseCalculoFgts;
    }

    public void setBaseCalculoFgts(Double baseCalculoFgts) {
        this.baseCalculoFgts = baseCalculoFgts;
    }

    @Column(name="ALIQUOTA_FGTS", precision=15, scale=2)
    public Double getAliquotaFgts() {
        return this.aliquotaFgts;
    }

    public void setAliquotaFgts(Double aliquotaFgts) {
        this.aliquotaFgts = aliquotaFgts;
    }

    @Column(name="VALOR_FGTS", precision=15, scale=2)
    public Double getValorFgts() {
        return this.valorFgts;
    }

    public void setValorFgts(Double valorFgts) {
        this.valorFgts = valorFgts;
    }

    @Column(name="DIAS_TRABALHADOS", precision=15, scale=2)
    public Double getDiasTrabalhados() {
        return this.diasTrabalhados;
    }

    public void setDiasTrabalhados(Double diasTrabalhados) {
        this.diasTrabalhados = diasTrabalhados;
    }

    @Column(name="DIAS_FOLGAS", precision=15, scale=2)
    public Double getDiasFolgas() {
        return this.diasFolgas;
    }

    public void setDiasFolgas(Double diasFolgas) {
        this.diasFolgas = diasFolgas;
    }

    @Column(name="DIAS_FERIADOS", precision=15, scale=2)
    public Double getDiasFeriados() {
        return this.diasFeriados;
    }

    public void setDiasFeriados(Double diasFeriados) {
        this.diasFeriados = diasFeriados;
    }

    @Column(name="FILHO_SALARIO_FAMILIA", precision=15, scale=2)
    public Double getFilhoSalarioFamilia() {
        return this.filhoSalarioFamilia;
    }

    public void setFilhoSalarioFamilia(Double filhoSalarioFamilia) {
        this.filhoSalarioFamilia = filhoSalarioFamilia;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getColaborador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="PAGAMENTO_APOS_CONVOCACAO")
    public Short getPagamentoAposConvocacao() {
        return this.pagamentoAposConvocacao;
    }

    public void setPagamentoAposConvocacao(Short pagamentoAposConvocacao) {
        this.pagamentoAposConvocacao = pagamentoAposConvocacao;
    }
}

