/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.vo.Cooperado;
import com.touchcomp.basementor.model.vo.DiaExtratoCooperado;
import com.touchcomp.basementor.model.vo.ExtratoFornecimentoLeite;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="cooperado_extrato_leite")
public class CooperadoExtratoLeite
implements Serializable {
    private Long identificador;
    private ExtratoFornecimentoLeite extrato;
    private Cooperado cooperado;
    private List<DiaExtratoCooperado> diaExtrato = new ArrayList<DiaExtratoCooperado>();
    private String linha;
    private Double total = 0.0;
    private String codigoCooperativa;

    @Id
    @Column(nullable=false, unique=true, name="ID_COOPERADO_EXTRATO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_COOPERADO_EXTRATO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_EXTRATO_FORN_LEITE")
    @ManyToOne(fetch=FetchType.LAZY)
    public ExtratoFornecimentoLeite getExtrato() {
        return this.extrato;
    }

    public void setExtrato(ExtratoFornecimentoLeite extrato) {
        this.extrato = extrato;
    }

    @JoinColumn(name="ID_COOPERADO")
    @ManyToOne(fetch=FetchType.LAZY)
    public Cooperado getCooperado() {
        return this.cooperado;
    }

    public void setCooperado(Cooperado cooperado) {
        this.cooperado = cooperado;
    }

    @OneToMany(mappedBy="cooperadorExtrato", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<DiaExtratoCooperado> getDiaExtrato() {
        return this.diaExtrato;
    }

    public void setDiaExtrato(List<DiaExtratoCooperado> diaExtrato) {
        this.diaExtrato = diaExtrato;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getIdentificador().toString();
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="linha")
    public String getLinha() {
        return this.linha;
    }

    public void setLinha(String linha) {
        this.linha = linha;
    }

    @Column(name="total")
    public Double getTotal() {
        return this.total;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    @Column(name="codigo_cooperativa")
    public String getCodigoCooperativa() {
        return this.codigoCooperativa;
    }

    public void setCodigoCooperativa(String codigoCooperativa) {
        this.codigoCooperativa = codigoCooperativa;
    }
}

