/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.inject.InjectActualCompany;
import com.touchcomp.basementor.annotations.inject.InjectActualDate;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="COR", uniqueConstraints={@UniqueConstraint(name="UNQ1_COR_NOME", columnNames={"NOME"})})
public class Cor
implements InterfaceVO {
    private Long identificador;
    private String nome;
    private Empresa empresa;
    private Date dataCadastro;
    private Date dataAtualizacao;
    private String codSincronizacao;
    private String sigla;
    private String corHex;

    public Cor() {
    }

    public Cor(Long id, String n) {
        this.nome = n;
        this.identificador = id;
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_COR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_COR")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, unique=true, name="NOME", length=40)
    public String getNome() {
        return this.nome;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_COR_EMPRESA"))
    @InjectActualCompany
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    @InjectActualDate
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setIdentificador(Long idCor) {
        this.identificador = idCor;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Date getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Date dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="COD_SINCRONIZACAO", length=30)
    public String getCodSincronizacao() {
        return this.codSincronizacao;
    }

    public void setCodSincronizacao(String codSincronizacao) {
        this.codSincronizacao = codSincronizacao;
    }

    @Column(name="SIGLA")
    public String getSigla() {
        return this.sigla;
    }

    public void setSigla(String sigla) {
        this.sigla = sigla;
    }

    @Column(name="COR_HEX")
    public String getCorHex() {
        return this.corHex;
    }

    public void setCorHex(String corHex) {
        this.corHex = corHex;
    }
}

