/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ArquivamentoDoc;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemCotacaoVendas;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.MotivoDesistencia;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PreCotacaoVendas;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.SituacaoCotacaoVendas;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="COTACAO_VENDAS")
public class CotacaoVendas
implements InterfaceVO {
    private Long identificador;
    private Representante representante;
    private CondicoesPagamento condicoesPagamento;
    private String observacao;
    private Double percFrete = 0.0;
    private Double valorFrete = 0.0;
    private Double percDesconto = 0.0;
    private Double valorDesconto = 0.0;
    private Double valorBancoCredito = 0.0;
    private Double valorTotalBruto = 0.0;
    private Double valorTotal = 0.0;
    private TipoFrete tipoFrete;
    private NaturezaOperacao naturezaOperacao;
    private Double percSeguro = 0.0;
    private Double valorSeguro = 0.0;
    private Double percDespAcessoria = 0.0;
    private Double valorDespAcessoria = 0.0;
    private UnidadeFatCliente unidadeFatCliente;
    private Transportador transportador;
    private String condPagMut;
    private Double percDescFinanceiro = 0.0;
    private Double percComissao = 0.0;
    private Date dataEmissao;
    private Date dataCadastro;
    private Date dataPrevisaoSaida;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private List<ItemCotacaoVendas> itemCotacaoVendas = new ArrayList<ItemCotacaoVendas>();
    private Short desistencia = 0;
    private MotivoDesistencia motivoDesistencia;
    private String observacaoDesistencia;
    private Usuario usuario;
    private Pessoa comprador;
    private String nrPedidoCliente;
    private Date dataValidadeProposta;
    private List<Pedido> pedido = new ArrayList<Pedido>();
    private SituacaoCotacaoVendas situacaoCotacaoVendas;
    private Long prazoEntrega = 0L;
    private CotacaoVendas cotacaoVendasPai;
    private Double percFreteInf = 0.0;
    private Double valorFreteInf = 0.0;
    private Double percDescontoInf = 0.0;
    private Double valorDescontoInf = 0.0;
    private Double percSeguroInf = 0.0;
    private Double valorSeguroInf = 0.0;
    private Double percDespAcessoriaInf = 0.0;
    private Double valorDespAcessoriaInf = 0.0;
    private Short tipoDescontoInf = 0;
    private Short tipoFreteInf = 0;
    private Short tipoSeguroInf = 0;
    private Short tipoDespAcessInf = 0;
    private Double valorTotalComImpostos = 0.0;
    private String observacaoUsuario;
    private String motivoCancelamento;
    private ArquivamentoDoc arquivoDoc;
    private MeioPagamento meioPagamento;
    private Long codigoCotacao;
    private Long codigoCotacaoManual;
    private Short numeroRevisao = 0;
    private Short numeroRevisaoManual;
    private Short infManualCodRevisao = 0;
    private String nrPregao;
    private Date dataDesistencia;
    private Usuario usuarioCadastro;
    private PreCotacaoVendas preCotacaoVenda;
    private String obsComprador;
    private String localCarregamento;
    private String localDescarregamento;

    @Id
    @Column(name="ID_COTACAO_VENDAS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_COTACAO_VENDAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_COTACAO_VENDAS_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_REPRESENTANTE", foreignKey=@ForeignKey(name="FK_COTACAO_VENDAS_REPRESENTANTE"))
    public Representante getRepresentante() {
        return this.representante;
    }

    public void setRepresentante(Representante representante) {
        this.representante = representante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_CONDICOES_PAGAMENTO", foreignKey=@ForeignKey(name="FK_COTACAO_VENDAS_COND_PAG"))
    public CondicoesPagamento getCondicoesPagamento() {
        return this.condicoesPagamento;
    }

    public void setCondicoesPagamento(CondicoesPagamento condicoesPagamento) {
        this.condicoesPagamento = condicoesPagamento;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(nullable=false, name="PERC_FRETE", precision=15, scale=4)
    public Double getPercFrete() {
        return this.percFrete;
    }

    public void setPercFrete(Double percFrete) {
        this.percFrete = percFrete;
    }

    @Column(nullable=false, name="VALOR_FRETE", precision=15, scale=2)
    public Double getValorFrete() {
        return this.valorFrete;
    }

    public void setValorFrete(Double valorFrete) {
        this.valorFrete = valorFrete;
    }

    @Column(nullable=false, name="PERC_DESCONTO", precision=15, scale=4)
    public Double getPercDesconto() {
        return this.percDesconto;
    }

    public void setPercDesconto(Double percDesconto) {
        this.percDesconto = percDesconto;
    }

    @Column(nullable=false, name="VALOR_DESCONTO", precision=15, scale=2)
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Column(nullable=false, name="VALOR_BANCO_CREDITO", precision=15, scale=2)
    public Double getValorBancoCredito() {
        return this.valorBancoCredito;
    }

    public void setValorBancoCredito(Double valorBancoCredito) {
        this.valorBancoCredito = valorBancoCredito;
    }

    @Column(nullable=false, name="VALOR_TOTAL_BRUTO", precision=15, scale=2)
    public Double getValorTotalBruto() {
        return this.valorTotalBruto;
    }

    public void setValorTotalBruto(Double valorTotalBruto) {
        this.valorTotalBruto = valorTotalBruto;
    }

    @Column(nullable=false, name="VALOR_TOTAL", precision=15, scale=2)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Column(name="DATA_PREVISAO_SAIDA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataPrevisaoSaida() {
        return this.dataPrevisaoSaida;
    }

    public void setDataPrevisaoSaida(Date dataPrevisaoSaida) {
        this.dataPrevisaoSaida = dataPrevisaoSaida;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_NATUREZA_OPERACAO", foreignKey=@ForeignKey(name="FK_COTACAO_VENDAS_NAT_OPERACAO"))
    public NaturezaOperacao getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    public void setNaturezaOperacao(NaturezaOperacao naturezaOperacao) {
        this.naturezaOperacao = naturezaOperacao;
    }

    @Column(nullable=false, name="PERC_SEGURO", precision=15, scale=4)
    public Double getPercSeguro() {
        return this.percSeguro;
    }

    public void setPercSeguro(Double percSeguro) {
        this.percSeguro = percSeguro;
    }

    @Column(nullable=false, name="VALOR_SEGURO", precision=15, scale=2)
    public Double getValorSeguro() {
        return this.valorSeguro;
    }

    public void setValorSeguro(Double valorSeguro) {
        this.valorSeguro = valorSeguro;
    }

    @Column(nullable=false, name="PERC_DESP_ACESSORIA", precision=15, scale=4)
    public Double getPercDespAcessoria() {
        return this.percDespAcessoria;
    }

    public void setPercDespAcessoria(Double percDespAcessoria) {
        this.percDespAcessoria = percDespAcessoria;
    }

    @Column(nullable=false, name="VALOR_DESP_ACESSORIA", precision=15, scale=2)
    public Double getValorDespAcessoria() {
        return this.valorDespAcessoria;
    }

    public void setValorDespAcessoria(Double valorDespAcessoria) {
        this.valorDespAcessoria = valorDespAcessoria;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FAT_CLIENTE", foreignKey=@ForeignKey(name="FK_COTACAO_VENDAS_UNID_F_CLIENT"))
    public UnidadeFatCliente getUnidadeFatCliente() {
        return this.unidadeFatCliente;
    }

    public void setUnidadeFatCliente(UnidadeFatCliente unidadeFatCliente) {
        this.unidadeFatCliente = unidadeFatCliente;
    }

    @JoinColumn(name="ID_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_COTACAO_VENDAS_TRANSPORTADOR"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Transportador getTransportador() {
        return this.transportador;
    }

    public void setTransportador(Transportador transportador) {
        this.transportador = transportador;
    }

    @JoinColumn(name="ID_TIPO_FRETE", foreignKey=@ForeignKey(name="FK_COTACAO_VENDAS_TP_FRETE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoFrete getTipoFrete() {
        return this.tipoFrete;
    }

    public void setTipoFrete(TipoFrete tipoFrete) {
        this.tipoFrete = tipoFrete;
    }

    @Column(name="COND_PAG_MUT", length=100)
    public String getCondPagMut() {
        return this.condPagMut;
    }

    public void setCondPagMut(String condPagMut) {
        this.condPagMut = condPagMut;
    }

    @Column(name="PERC_DESC_FINANCEIRO", precision=15, scale=2)
    public Double getPercDescFinanceiro() {
        return this.percDescFinanceiro;
    }

    public void setPercDescFinanceiro(Double percDescFinanceiro) {
        this.percDescFinanceiro = percDescFinanceiro;
    }

    @Column(name="PERC_COMISSAO", precision=15, scale=2)
    public Double getPercComissao() {
        return this.percComissao;
    }

    public void setPercComissao(Double percComissaoGeral) {
        this.percComissao = percComissaoGeral;
    }

    @Column(name="DESISTENCIA")
    public Short getDesistencia() {
        return this.desistencia;
    }

    public void setDesistencia(Short desistencia) {
        this.desistencia = desistencia;
    }

    @JoinColumn(name="ID_MOTIVO_DESISTENCIA", foreignKey=@ForeignKey(name="FK_COTACAO_VENDAS_MOT_DESISTENC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public MotivoDesistencia getMotivoDesistencia() {
        return this.motivoDesistencia;
    }

    public void setMotivoDesistencia(MotivoDesistencia motivoDesistencia) {
        this.motivoDesistencia = motivoDesistencia;
    }

    @Column(name="OBSERVACAO_DESISTENCIA", length=500)
    public String getObservacaoDesistencia() {
        return this.observacaoDesistencia;
    }

    public void setObservacaoDesistencia(String observacaoDesistencia) {
        this.observacaoDesistencia = observacaoDesistencia;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Cotacao: {0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="cotacaoVendas", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @OrderBy(value="numeroItem")
    public List<ItemCotacaoVendas> getItemCotacaoVendas() {
        return this.itemCotacaoVendas;
    }

    public void setItemCotacaoVendas(List<ItemCotacaoVendas> itemCotacaoVendas) {
        this.itemCotacaoVendas = itemCotacaoVendas;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_COTACAO_VENDAS_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COMPRADOR", foreignKey=@ForeignKey(name="FK_COTACAO_VENDAS_COMPRADOR"))
    public Pessoa getComprador() {
        return this.comprador;
    }

    public void setComprador(Pessoa comprador) {
        this.comprador = comprador;
    }

    @Column(name="NR_PEDIDO_CLIENTE", length=15)
    public String getNrPedidoCliente() {
        return this.nrPedidoCliente;
    }

    public void setNrPedidoCliente(String nrPedidoCliente) {
        this.nrPedidoCliente = nrPedidoCliente;
    }

    @Column(name="DATA_VALIDADE_PROPOSTA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataValidadeProposta() {
        return this.dataValidadeProposta;
    }

    public void setDataValidadeProposta(Date dataValidadeProposta) {
        this.dataValidadeProposta = dataValidadeProposta;
    }

    @OneToMany(mappedBy="cotacaoVendas")
    public List<Pedido> getPedido() {
        return this.pedido;
    }

    public void setPedido(List<Pedido> pedido) {
        this.pedido = pedido;
    }

    @JoinColumn(name="ID_SITUACAO_COTACAO_VENDAS", foreignKey=@ForeignKey(name="FK_COTACAO_VENDAS_SIT_COT_VENDA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public SituacaoCotacaoVendas getSituacaoCotacaoVendas() {
        return this.situacaoCotacaoVendas;
    }

    public void setSituacaoCotacaoVendas(SituacaoCotacaoVendas situacaoCotacaoVendas) {
        this.situacaoCotacaoVendas = situacaoCotacaoVendas;
    }

    @Column(name="PRAZO_ENTREGA")
    public Long getPrazoEntrega() {
        return this.prazoEntrega;
    }

    public void setPrazoEntrega(Long prazoEntrega) {
        this.prazoEntrega = prazoEntrega;
    }

    @Column(name="PERC_FRETE_INF", precision=15, scale=4)
    public Double getPercFreteInf() {
        return this.percFreteInf;
    }

    public void setPercFreteInf(Double percFreteInf) {
        this.percFreteInf = percFreteInf;
    }

    @Column(name="VALOR_FRETE_INF", precision=15, scale=2)
    public Double getValorFreteInf() {
        return this.valorFreteInf;
    }

    public void setValorFreteInf(Double valorFreteInf) {
        this.valorFreteInf = valorFreteInf;
    }

    @Column(name="PERC_DESCONTO_INF", precision=15, scale=4)
    public Double getPercDescontoInf() {
        return this.percDescontoInf;
    }

    public void setPercDescontoInf(Double percDescontoInf) {
        this.percDescontoInf = percDescontoInf;
    }

    @Column(name="VALOR_DESCONTO_INF", precision=15, scale=2)
    public Double getValorDescontoInf() {
        return this.valorDescontoInf;
    }

    public void setValorDescontoInf(Double valorDescontoInf) {
        this.valorDescontoInf = valorDescontoInf;
    }

    @Column(name="PERC_SEGURO_INF", precision=15, scale=4)
    public Double getPercSeguroInf() {
        return this.percSeguroInf;
    }

    public void setPercSeguroInf(Double percSeguroInf) {
        this.percSeguroInf = percSeguroInf;
    }

    @Column(name="VALOR_SEGURO_INF", precision=15, scale=2)
    public Double getValorSeguroInf() {
        return this.valorSeguroInf;
    }

    public void setValorSeguroInf(Double valorSeguroInf) {
        this.valorSeguroInf = valorSeguroInf;
    }

    @Column(name="PERC_DESP_ACESSORIA_INF", precision=15, scale=4)
    public Double getPercDespAcessoriaInf() {
        return this.percDespAcessoriaInf;
    }

    public void setPercDespAcessoriaInf(Double percDespAcessoriaInf) {
        this.percDespAcessoriaInf = percDespAcessoriaInf;
    }

    @Column(name="VALOR_DESP_ACESSORIA_INF", precision=15, scale=2)
    public Double getValorDespAcessoriaInf() {
        return this.valorDespAcessoriaInf;
    }

    public void setValorDespAcessoriaInf(Double valorDespAcessoriaInf) {
        this.valorDespAcessoriaInf = valorDespAcessoriaInf;
    }

    @Column(name="TIPO_DESCONTO_INF")
    public Short getTipoDescontoInf() {
        return this.tipoDescontoInf;
    }

    public void setTipoDescontoInf(Short tipoDescontoInf) {
        this.tipoDescontoInf = tipoDescontoInf;
    }

    @Column(name="TIPO_FRETE_INF")
    public Short getTipoFreteInf() {
        return this.tipoFreteInf;
    }

    public void setTipoFreteInf(Short tipoFreteInf) {
        this.tipoFreteInf = tipoFreteInf;
    }

    @Column(name="TIPO_SEGURO_INF")
    public Short getTipoSeguroInf() {
        return this.tipoSeguroInf;
    }

    public void setTipoSeguroInf(Short tipoSeguroInf) {
        this.tipoSeguroInf = tipoSeguroInf;
    }

    @Column(name="TIPO_DESP_ACESS_INF")
    public Short getTipoDespAcessInf() {
        return this.tipoDespAcessInf;
    }

    public void setTipoDespAcessInf(Short tipoDespAcessInf) {
        this.tipoDespAcessInf = tipoDespAcessInf;
    }

    @Column(name="VALOR_TOTAL_COM_IMPOSTOS", precision=15, scale=2)
    public Double getValorTotalComImpostos() {
        return this.valorTotalComImpostos;
    }

    public void setValorTotalComImpostos(Double valorTotalComImpostos) {
        this.valorTotalComImpostos = valorTotalComImpostos;
    }

    @Column(name="NUMERO_REVISAO")
    @Generated(value=GenerationTime.INSERT)
    public Short getNumeroRevisao() {
        return this.numeroRevisao;
    }

    public void setNumeroRevisao(Short numeroRevisao) {
        this.numeroRevisao = numeroRevisao;
    }

    @JoinColumn(name="ID_COTACAO_VENDAS_PAI", foreignKey=@ForeignKey(name="FK_COTACAO_VENDAS_COT_VENDAS_PA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CotacaoVendas getCotacaoVendasPai() {
        return this.cotacaoVendasPai;
    }

    public void setCotacaoVendasPai(CotacaoVendas cotacaoVendasPai) {
        this.cotacaoVendasPai = cotacaoVendasPai;
    }

    @Column(name="OBSERVACAO_USUARIO", length=5000)
    public String getObservacaoUsuario() {
        return this.observacaoUsuario;
    }

    public void setObservacaoUsuario(String observacaoUsuario) {
        this.observacaoUsuario = observacaoUsuario;
    }

    @Column(name="MOTIVO_CANCELAMENTO", length=200)
    public String getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    public void setMotivoCancelamento(String motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @JoinColumn(name="ID_ARQUIVO_DOC", foreignKey=@ForeignKey(name="FK_COTACAO_VENDAS_ARQ_DOC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ArquivamentoDoc getArquivoDoc() {
        return this.arquivoDoc;
    }

    public void setArquivoDoc(ArquivamentoDoc arquivoDoc) {
        this.arquivoDoc = arquivoDoc;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_COT_VENDAS_MEIO_PAGAMENTO"))
    public MeioPagamento getMeioPagamento() {
        return this.meioPagamento;
    }

    public void setMeioPagamento(MeioPagamento meioPagamento) {
        this.meioPagamento = meioPagamento;
    }

    @Column(name="CODIGO_COTACAO")
    @Generated(value=GenerationTime.INSERT)
    public Long getCodigoCotacao() {
        return this.codigoCotacao;
    }

    public void setCodigoCotacao(Long codigoCotacao) {
        this.codigoCotacao = codigoCotacao;
    }

    @Ignore
    @Column(name="CODIGO_COTACAO_MANUAL")
    public Long getCodigoCotacaoManual() {
        return this.codigoCotacaoManual;
    }

    public void setCodigoCotacaoManual(Long codigoCotacaoManual) {
        this.codigoCotacaoManual = codigoCotacaoManual;
    }

    @Ignore
    @Column(name="NUMERO_REVISAO_MANUAL")
    public Short getNumeroRevisaoManual() {
        return this.numeroRevisaoManual;
    }

    public void setNumeroRevisaoManual(Short numeroRevisaoManual) {
        this.numeroRevisaoManual = numeroRevisaoManual;
    }

    @Column(name="INF_MANUAL_COD_REVISAO")
    public Short getInfManualCodRevisao() {
        return this.infManualCodRevisao;
    }

    public void setInfManualCodRevisao(Short infManualCodRevisao) {
        this.infManualCodRevisao = infManualCodRevisao;
    }

    @Column(name="NR_PREGAO", length=15)
    public String getNrPregao() {
        return this.nrPregao;
    }

    public void setNrPregao(String nrPregao) {
        this.nrPregao = nrPregao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_DESISTENCIA")
    public Date getDataDesistencia() {
        return this.dataDesistencia;
    }

    public void setDataDesistencia(Date date) {
        this.dataDesistencia = date;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_CADASTRO", foreignKey=@ForeignKey(name="FK_USUARIO_CADASTRO"))
    public Usuario getUsuarioCadastro() {
        return this.usuarioCadastro;
    }

    public void setUsuarioCadastro(Usuario usuario) {
        this.usuarioCadastro = usuario;
    }

    @ManyToOne(fetch=FetchType.LAZY, targetEntity=PreCotacaoVendas.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="ID_PRE_COTACAO_VENDA", foreignKey=@ForeignKey(name="FK_PRE_COTACAO_VENDAS_COT_VENDA"))
    public PreCotacaoVendas getPreCotacaoVenda() {
        return this.preCotacaoVenda;
    }

    public void setPreCotacaoVenda(PreCotacaoVendas preCotacaoVenda) {
        this.preCotacaoVenda = preCotacaoVenda;
    }

    @Column(name="OBS_COMPRADOR", length=200)
    public String getObsComprador() {
        return this.obsComprador;
    }

    public void setObsComprador(String obsComprador) {
        this.obsComprador = obsComprador;
    }

    @Column(name="LOCAL_CARREGAMENTO", length=1000)
    public String getLocalCarregamento() {
        return this.localCarregamento;
    }

    public void setLocalCarregamento(String localCarregamento) {
        this.localCarregamento = localCarregamento;
    }

    @Column(name="LOCAL_DESCARREGAMENTO", length=1000)
    public String getLocalDescarregamento() {
        return this.localDescarregamento;
    }

    public void setLocalDescarregamento(String localDescarregamento) {
        this.localDescarregamento = localDescarregamento;
    }
}

