/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.cte.aquaviario.EnumConstTipoNavegacao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.CteBalsa;
import com.touchcomp.basementor.model.vo.CteContainer;
import com.touchcomp.basementor.model.vo.Embarcacao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CTE_AQUAVIARIO")
public class CteAquaviario
implements InterfaceVO {
    @Id
    @Column(nullable=false, name="ID_CTE_AQUAVIARIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CTE_AQUAVIARIO")
    private Long identificador;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CTE", foreignKey=@ForeignKey(name="FK_CTE_AQUAVIARIO_CTE"))
    private Cte cte;
    @Column(name="BC_AFRMM", precision=13, scale=2)
    private Double bcAfrmm = 0.0;
    @Column(name="VLR_AFRMM", precision=13, scale=2)
    private Double vlrAfrmm = 0.0;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMBARCACAO", foreignKey=@ForeignKey(name="FK_CTE_AQUAVIARIO_EMBARCACAO"))
    private Embarcacao navio;
    @Column(name="NUMERO_VIAGEM")
    private Integer numeroViagem = 0;
    @Column(name="DIRECAO", length=1)
    private String direcao;
    @Column(name="TIPO_NAVEGACAO")
    private Short tipoNavegacao = EnumConstTipoNavegacao.TIPO_NAVEGACAO_INTERIOR.getEnumId();
    @OneToMany(mappedBy="cteAquaviario", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    private List<CteBalsa> balsas = new ArrayList<CteBalsa>();
    @OneToMany(mappedBy="cteAquaviario", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    private List<CteContainer> containers = new ArrayList<CteContainer>();

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public Cte getCte() {
        return this.cte;
    }

    @Generated
    public Double getBcAfrmm() {
        return this.bcAfrmm;
    }

    @Generated
    public Double getVlrAfrmm() {
        return this.vlrAfrmm;
    }

    @Generated
    public Embarcacao getNavio() {
        return this.navio;
    }

    @Generated
    public Integer getNumeroViagem() {
        return this.numeroViagem;
    }

    @Generated
    public String getDirecao() {
        return this.direcao;
    }

    @Generated
    public Short getTipoNavegacao() {
        return this.tipoNavegacao;
    }

    @Generated
    public List<CteBalsa> getBalsas() {
        return this.balsas;
    }

    @Generated
    public List<CteContainer> getContainers() {
        return this.containers;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setCte(Cte cte) {
        this.cte = cte;
    }

    @Generated
    public void setBcAfrmm(Double bcAfrmm) {
        this.bcAfrmm = bcAfrmm;
    }

    @Generated
    public void setVlrAfrmm(Double vlrAfrmm) {
        this.vlrAfrmm = vlrAfrmm;
    }

    @Generated
    public void setNavio(Embarcacao navio) {
        this.navio = navio;
    }

    @Generated
    public void setNumeroViagem(Integer numeroViagem) {
        this.numeroViagem = numeroViagem;
    }

    @Generated
    public void setDirecao(String direcao) {
        this.direcao = direcao;
    }

    @Generated
    public void setTipoNavegacao(Short tipoNavegacao) {
        this.tipoNavegacao = tipoNavegacao;
    }

    @Generated
    public void setBalsas(List<CteBalsa> balsas) {
        this.balsas = balsas;
    }

    @Generated
    public void setContainers(List<CteContainer> containers) {
        this.containers = containers;
    }
}

