/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.ItemProdNFCTeInf;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.UnidadeFatTransporte;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="CTE_NF")
public class CteNf
implements InterfaceVO {
    private Long identificador;
    private Cte cte;
    private String nrRomaneio;
    private String nrPedido;
    private String serie;
    private Long numero;
    private Date dataEmissao;
    private Double vrBcIcms = 0.0;
    private Double vrIcms = 0.0;
    private Double vrBcIcmsSt = 0.0;
    private Double vrIcmsSt = 0.0;
    private Double vrProdutos = 0.0;
    private Double vrTotal = 0.0;
    private Cfop cfop;
    private Double peso = 0.0;
    private String pinSuframa;
    private UnidadeFatTransporte remetenteRetirada;
    private ModeloDocFiscal modeloDocFiscal;
    private Double qtdTotalNF = 0.0;
    private Double qtdTotalVolumesNf = 0.0;
    private Double pesoTotalNf = 0.0;
    private List<ItemProdNFCTeInf> itemProdNFCteInf = new ArrayList<ItemProdNFCTeInf>();

    @Id
    @Column(name="ID_CTE_NF")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CTE_NF")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_CTE", foreignKey=@ForeignKey(name="FK_CTE_NF_CTE"))
    public Cte getCte() {
        return this.cte;
    }

    public void setCte(Cte cte) {
        this.cte = cte;
    }

    @Column(name="NR_ROMANEIO", length=20)
    public String getNrRomaneio() {
        return this.nrRomaneio;
    }

    public void setNrRomaneio(String nrRomaneio) {
        this.nrRomaneio = nrRomaneio;
    }

    @Column(name="NR_PEDIDO", length=20)
    public String getNrPedido() {
        return this.nrPedido;
    }

    public void setNrPedido(String nrPedido) {
        this.nrPedido = nrPedido;
    }

    @Column(name="SERIE", length=3)
    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String serie) {
        this.serie = serie;
    }

    @Ignore
    @Column(name="NUMERO")
    public Long getNumero() {
        return this.numero;
    }

    public void setNumero(Long numero) {
        this.numero = numero;
    }

    @Column(name="DATA_EMISSAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Column(name="VR_BC_ICMS", precision=12, scale=2)
    public Double getVrBcIcms() {
        return this.vrBcIcms;
    }

    public void setVrBcIcms(Double vrBcIcms) {
        this.vrBcIcms = vrBcIcms;
    }

    @Column(name="VR_ICMS", precision=12, scale=2)
    public Double getVrIcms() {
        return this.vrIcms;
    }

    public void setVrIcms(Double vrIcms) {
        this.vrIcms = vrIcms;
    }

    @Column(name="VR_BC_ICMS_ST", precision=12, scale=2)
    public Double getVrBcIcmsSt() {
        return this.vrBcIcmsSt;
    }

    public void setVrBcIcmsSt(Double vrBcIcmsSt) {
        this.vrBcIcmsSt = vrBcIcmsSt;
    }

    @Column(name="VR_ICMS_ST", precision=12, scale=2)
    public Double getVrIcmsSt() {
        return this.vrIcmsSt;
    }

    public void setVrIcmsSt(Double vrIcmsSt) {
        this.vrIcmsSt = vrIcmsSt;
    }

    @Column(name="VR_PRODUTOS", precision=12, scale=2)
    public Double getVrProdutos() {
        return this.vrProdutos;
    }

    public void setVrProdutos(Double vrProdutos) {
        this.vrProdutos = vrProdutos;
    }

    @Column(name="VR_TOTAL", precision=12, scale=2)
    public Double getVrTotal() {
        return this.vrTotal;
    }

    public void setVrTotal(Double vrTotal) {
        this.vrTotal = vrTotal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_CFOP", foreignKey=@ForeignKey(name="FK_CTE_NF_FROP"))
    public Cfop getCfop() {
        return this.cfop;
    }

    public void setCfop(Cfop cfop) {
        this.cfop = cfop;
    }

    @Column(name="PESO", precision=12, scale=2)
    public Double getPeso() {
        return this.peso;
    }

    public void setPeso(Double peso) {
        this.peso = peso;
    }

    @Column(name="PIN_SUFRAMA", length=10)
    public String getPinSuframa() {
        return this.pinSuframa;
    }

    public void setPinSuframa(String pinSuframa) {
        this.pinSuframa = pinSuframa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REMETENTE_RETIRA", foreignKey=@ForeignKey(name="FK_CTE_NF_REM_RETIRA"))
    public UnidadeFatTransporte getRemetenteRetirada() {
        return this.remetenteRetirada;
    }

    public void setRemetenteRetirada(UnidadeFatTransporte remetenteRetirada) {
        this.remetenteRetirada = remetenteRetirada;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getNumero() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNumero()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_DOC_FISCAL", foreignKey=@ForeignKey(name="FK_CTE_NF_MOD_DOC_FISCAL"))
    public ModeloDocFiscal getModeloDocFiscal() {
        return this.modeloDocFiscal;
    }

    public void setModeloDocFiscal(ModeloDocFiscal modeloDocFiscal) {
        this.modeloDocFiscal = modeloDocFiscal;
    }

    @Column(name="QTD_TOTAL_NF", precision=15, scale=6)
    public Double getQtdTotalNF() {
        return this.qtdTotalNF;
    }

    public void setQtdTotalNF(Double qtdTotalNF) {
        this.qtdTotalNF = qtdTotalNF;
    }

    @OneToMany(targetEntity=ItemProdNFCTeInf.class, fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @JoinTable(name="cte_nf_item_pr_inf", joinColumns={@JoinColumn(name="id_cte_nf")}, inverseJoinColumns={@JoinColumn(name="id_item_prod_nf_cte_inf")})
    public List<ItemProdNFCTeInf> getItemProdNFCteInf() {
        return this.itemProdNFCteInf;
    }

    public void setItemProdNFCteInf(List<ItemProdNFCTeInf> itemProdNFCteInf) {
        this.itemProdNFCteInf = itemProdNFCteInf;
    }

    @Column(name="QTD_TOTAL_VOLUMES_NF", precision=15, scale=6)
    public Double getQtdTotalVolumesNf() {
        return this.qtdTotalVolumesNf;
    }

    public void setQtdTotalVolumesNf(Double qtdTotalVolumesNf) {
        this.qtdTotalVolumesNf = qtdTotalVolumesNf;
    }

    @Column(nullable=false, name="PESO_TOTAL_NF", precision=15, scale=6)
    public Double getPesoTotalNf() {
        return this.pesoTotalNf;
    }

    public void setPesoTotalNf(Double pesoTotalNf) {
        this.pesoTotalNf = pesoTotalNf;
    }
}

