/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Ctrc;
import com.touchcomp.basementor.model.vo.CtrcColetaEntrega;
import com.touchcomp.basementor.model.vo.CtrcDocumentosFiscais;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CTRC_CARGA_TRANSPORTADA")
public class CtrcCargaTransportada
implements InterfaceVO {
    private Long identificador;
    private String despacho;
    private String cnpjRemetente;
    private String inscEstRemetente;
    private String codMunOrigem;
    private String cnpjDestinatario;
    private String inscEstDestinatario;
    private String codMunDestinatario;
    private Ctrc ctrc;
    private CtrcColetaEntrega ctrcColetaEntrega;
    private List<CtrcDocumentosFiscais> ctrcDocFiscais = new ArrayList<CtrcDocumentosFiscais>();

    @Id
    @Column(name="ID_CTRC_CARGA_TRANSPORTADA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CTRC_CARGA_TRANSPORTADA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESPACHO", length=20)
    public String getDespacho() {
        return this.despacho;
    }

    public void setDespacho(String despacho) {
        this.despacho = despacho;
    }

    @Column(name="CNPJ_REMETENTE", length=14)
    public String getCnpjRemetente() {
        return this.cnpjRemetente;
    }

    public void setCnpjRemetente(String cnpjRemetente) {
        this.cnpjRemetente = cnpjRemetente;
    }

    @Column(name="INSC_EST_REMETENTE", length=14)
    public String getInscEstRemetente() {
        return this.inscEstRemetente;
    }

    public void setInscEstRemetente(String inscEstRemetente) {
        this.inscEstRemetente = inscEstRemetente;
    }

    @Column(name="COD_MUN_ORIGEM", length=7)
    public String getCodMunOrigem() {
        return this.codMunOrigem;
    }

    public void setCodMunOrigem(String codMunOrigem) {
        this.codMunOrigem = codMunOrigem;
    }

    @Column(name="CNPJ_DESTINATARIO", length=14)
    public String getCnpjDestinatario() {
        return this.cnpjDestinatario;
    }

    public void setCnpjDestinatario(String cnpjDestinatario) {
        this.cnpjDestinatario = cnpjDestinatario;
    }

    @Column(name="INSC_EST_DESTINATARIO", length=14)
    public String getInscEstDestinatario() {
        return this.inscEstDestinatario;
    }

    public void setInscEstDestinatario(String inscEstDestinatario) {
        this.inscEstDestinatario = inscEstDestinatario;
    }

    @Column(name="COD_MUN_DESTINATARIO", length=7)
    public String getCodMunDestinatario() {
        return this.codMunDestinatario;
    }

    public void setCodMunDestinatario(String codMunDestinatario) {
        this.codMunDestinatario = codMunDestinatario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_CTRC", foreignKey=@ForeignKey(name="FK_CTRC_CARGA_TRANSPORTADA_CTRC"))
    public Ctrc getCtrc() {
        return this.ctrc;
    }

    public void setCtrc(Ctrc ctrc) {
        this.ctrc = ctrc;
    }

    @OneToOne(mappedBy="ctrcCargaTransportada", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public CtrcColetaEntrega getCtrcColetaEntrega() {
        return this.ctrcColetaEntrega;
    }

    public void setCtrcColetaEntrega(CtrcColetaEntrega ctrcColetaEntrega) {
        this.ctrcColetaEntrega = ctrcColetaEntrega;
    }

    @OneToMany(mappedBy="ctrcCargaTransportada", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<CtrcDocumentosFiscais> getCtrcDocFiscais() {
        return this.ctrcDocFiscais;
    }

    public void setCtrcDocFiscais(List<CtrcDocumentosFiscais> ctrcDocFiscais) {
        this.ctrcDocFiscais = ctrcDocFiscais;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDespacho()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

