/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClienteFinancContSistemas;
import com.touchcomp.basementor.model.vo.CustoMensalModulo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="CUSTO_MENSAL")
public class CustoMensal
implements InterfaceVO {
    private Long identificador;
    private ClienteFinancContSistemas clienteFinancContSistemas;
    private Double valor = 0.0;
    private Date dataInicial;
    private Date dataFinal;
    private List<CustoMensalModulo> custoMensalModulo = new ArrayList<CustoMensalModulo>();

    @Id
    @Column(name="ID_CUSTO_MENSAL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CUSTO_MENSAL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_CLIENTE_FINAN_CONT_SISTEMAS", foreignKey=@ForeignKey(name="FK_CUSTO_MENSAL_CLI_FINANCEIRO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ClienteFinancContSistemas getClienteFinancContSistemas() {
        return this.clienteFinancContSistemas;
    }

    public void setClienteFinancContSistemas(ClienteFinancContSistemas clienteFinancContSistemas) {
        this.clienteFinancContSistemas = clienteFinancContSistemas;
    }

    @Column(nullable=false, name="VALOR", precision=15, scale=2)
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} / {1} - {2}", (Object[])new Object[]{this.getIdentificador(), this.getDataInicial(), this.getDataFinal()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="custoMensal")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<CustoMensalModulo> getCustoMensalModulo() {
        return this.custoMensalModulo;
    }

    public void setCustoMensalModulo(List<CustoMensalModulo> custoMensalModulo) {
        this.custoMensalModulo = custoMensalModulo;
    }
}

