/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.DeParaFornecedorCentroEstoque;
import com.touchcomp.basementor.model.vo.DeParaFornecedorEmpresa;
import com.touchcomp.basementor.model.vo.DeParaFornecedorForn;
import com.touchcomp.basementor.model.vo.DeParaFornecedorItem;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="DEPARA_FORNECEDOR")
public class DeParaFornecedor
implements InterfaceVO {
    private Long identificador;
    private Fornecedor fornecedor;
    private NaturezaOperacao naturezaOperacao;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private NaturezaOperacao naturezaOperacaoSaida;
    private Short utilizaProdutoDiferente = 0;
    private List<DeParaFornecedorCentroEstoque> centroEstoques = new ArrayList<DeParaFornecedorCentroEstoque>();
    private List<DeParaFornecedorItem> itens;
    private List<DeParaFornecedorEmpresa> empresas = new ArrayList<DeParaFornecedorEmpresa>();
    private List<DeParaFornecedorForn> fornecedores = new ArrayList<DeParaFornecedorForn>();
    private String descricao;

    public DeParaFornecedor() {
        this.itens = new ArrayList<DeParaFornecedorItem>();
    }

    @Id
    @Column(name="ID_DEPARA_FORNECEDOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_DEPARA_FORNECEDOR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FORNECEDOR", foreignKey=@ForeignKey(name="FK_DEPARA_FORNECEDOR_FORN"))
    public Fornecedor getFornecedor() {
        return this.fornecedor;
    }

    public void setFornecedor(Fornecedor fornecedor) {
        this.fornecedor = fornecedor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_OPERACAO", foreignKey=@ForeignKey(name="FK_DEPARA_FORN_NAT_OP"))
    public NaturezaOperacao getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    public void setNaturezaOperacao(NaturezaOperacao naturezaOperacao) {
        this.naturezaOperacao = naturezaOperacao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}-Fornecedor: {1}", (Object[])new Object[]{this.getIdentificador(), this.getFornecedor() != null ? this.getFornecedor().getPessoa().getNome() : ""});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_OPERACAO_SAIDA", foreignKey=@ForeignKey(name="FK_DEPARA_FORN_NAT_OP_SAIDA"))
    public NaturezaOperacao getNaturezaOperacaoSaida() {
        return this.naturezaOperacaoSaida;
    }

    public void setNaturezaOperacaoSaida(NaturezaOperacao naturezaOperacaoSaida) {
        this.naturezaOperacaoSaida = naturezaOperacaoSaida;
    }

    @Column(name="UTILIZAR_PRODUTO_DIFERENTE")
    public Short getUtilizaProdutoDiferente() {
        return this.utilizaProdutoDiferente;
    }

    public void setUtilizaProdutoDiferente(Short utilizaProdutoDiferente) {
        this.utilizaProdutoDiferente = utilizaProdutoDiferente;
    }

    @OneToMany(mappedBy="deParaFornecedor", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<DeParaFornecedorCentroEstoque> getCentroEstoques() {
        return this.centroEstoques;
    }

    public void setCentroEstoques(List<DeParaFornecedorCentroEstoque> centroEstoques) {
        this.centroEstoques = centroEstoques;
    }

    @OneToMany(mappedBy="deParaFornecedor", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<DeParaFornecedorItem> getItens() {
        return this.itens;
    }

    public void setItens(List<DeParaFornecedorItem> itens) {
        this.itens = itens;
    }

    @OneToMany(mappedBy="deParaFornecedor", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<DeParaFornecedorEmpresa> getEmpresas() {
        return this.empresas;
    }

    public void setEmpresas(List<DeParaFornecedorEmpresa> empresas) {
        this.empresas = empresas;
    }

    @Column(name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @OneToMany(mappedBy="deParaFornecedor", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<DeParaFornecedorForn> getFornecedores() {
        return this.fornecedores;
    }

    public void setFornecedores(List<DeParaFornecedorForn> fornecedores) {
        this.fornecedores = fornecedores;
    }
}

