/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BemTipoDepreciacao;
import com.touchcomp.basementor.model.vo.ItemCiapDepreciacaoBaixaBem;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MovBemSpedPisCofins;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="DEPRECIACAO_BEM")
public class DepreciacaoBem
implements InterfaceVO {
    private Long identificador;
    private BemTipoDepreciacao bemTipoDepreciacao;
    private Double valorDepreciacao = 0.0;
    private Double valorDeprecAcelerada = 0.0;
    private LoteContabil loteContabil;
    private LancamentoCtbGerencial lancamentoCtbGerencial;
    private List<MovBemSpedPisCofins> movBemSpedPisCofins = new ArrayList<MovBemSpedPisCofins>();
    private ItemCiapDepreciacaoBaixaBem itemCiapDepreciacaoBaixaBem;

    @Id
    @Column(name="ID_DEPRECIACAO_BEM")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_DEPRECIACAO_BEM")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BEM_TIPO_DEPRECIACAO", foreignKey=@ForeignKey(name="FK_DEPRECIACAO_BEM_TP_DEPR"))
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public BemTipoDepreciacao getBemTipoDepreciacao() {
        return this.bemTipoDepreciacao;
    }

    public void setBemTipoDepreciacao(BemTipoDepreciacao bemTipoDepreciacao) {
        this.bemTipoDepreciacao = bemTipoDepreciacao;
    }

    @Column(nullable=false, name="VALOR_DEPRECIACAO", precision=15, scale=2)
    public Double getValorDepreciacao() {
        return this.valorDepreciacao;
    }

    public void setValorDepreciacao(Double valorDepreciacao) {
        this.valorDepreciacao = valorDepreciacao;
    }

    @Column(nullable=false, name="VALOR_DEPREC_ACELERADA", precision=15, scale=2)
    public Double getValorDeprecAcelerada() {
        return this.valorDeprecAcelerada;
    }

    public void setValorDeprecAcelerada(Double valorDeprecAcelerada) {
        this.valorDeprecAcelerada = valorDeprecAcelerada;
    }

    @JoinColumn(name="ID_LOTE_CONTABIL", foreignKey=@ForeignKey(name="FK_DEPRECIACAO_BEM_LOTE_CTB"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManyToOne(fetch=FetchType.LAZY)
    public LoteContabil getLoteContabil() {
        return this.loteContabil;
    }

    public void setLoteContabil(LoteContabil loteContabil) {
        this.loteContabil = loteContabil;
    }

    @JoinColumn(name="ID_LANCAMENTO_CTB_GER", foreignKey=@ForeignKey(name="FK_DEPRECIACAO_BEM_LANC_CTB_GER"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManyToOne(fetch=FetchType.LAZY)
    public LancamentoCtbGerencial getLancamentoCtbGerencial() {
        return this.lancamentoCtbGerencial;
    }

    public void setLancamentoCtbGerencial(LancamentoCtbGerencial lancamentoCtbGerencial) {
        this.lancamentoCtbGerencial = lancamentoCtbGerencial;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getBemTipoDepreciacao() != null ? this.getBemTipoDepreciacao().getBem().getDescricao() : this.getBemTipoDepreciacao(), this.getBemTipoDepreciacao() != null ? this.getBemTipoDepreciacao().getTipoDepreciacao().getDescricao() : this.getBemTipoDepreciacao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(targetEntity=MovBemSpedPisCofins.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinTable(name="DEPR_BEM_MOV_PIS_COFINS", joinColumns={@JoinColumn(name="ID_DEPRECIACAO_BEM")}, inverseJoinColumns={@JoinColumn(name="ID_MOV_BEM_SPED_PIS_COFINS")})
    public List<MovBemSpedPisCofins> getMovBemSpedPisCofins() {
        return this.movBemSpedPisCofins;
    }

    public void setMovBemSpedPisCofins(List<MovBemSpedPisCofins> movBemSpedPisCofins) {
        this.movBemSpedPisCofins = movBemSpedPisCofins;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_CIAP_DEPR_BAIXA_BEM", foreignKey=@ForeignKey(name="FK_DEPRECIACAO_BEM_IT_CIAP_DEPR"))
    public ItemCiapDepreciacaoBaixaBem getItemCiapDepreciacaoBaixaBem() {
        return this.itemCiapDepreciacaoBaixaBem;
    }

    public void setItemCiapDepreciacaoBaixaBem(ItemCiapDepreciacaoBaixaBem itemCiapDepreciacaoBaixaBem) {
        this.itemCiapDepreciacaoBaixaBem = itemCiapDepreciacaoBaixaBem;
    }
}

