/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemCiapDepreciacaoBaixaBem;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="DEPRECIACAO_CIAP")
public class DepreciacaoCiap
implements InterfaceVO {
    private Long identificador;
    private Date periodo;
    private Short numeroTurnos = 0;
    private Short gerarCiap = 0;
    private Short gerarDepreciacao = 0;
    private Double valorTribExportacao = 0.0;
    private Double totalSaidas = 0.0;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Double vlrTotIcms = 0.0;
    private Double vlrTotIcmsNaoAprop = 0.0;
    private Double vlrTotDepr = 0.0;
    private Double vlrTotDeprAcel = 0.0;
    private Double vlrTotIcmsFrete = 0.0;
    private Double vlrTotIcmsFretNaoAprop = 0.0;
    private Double vlrTotIcmsDifAliq = 0.0;
    private Double vlrTotIcmsDifAliqNaoAprop = 0.0;
    private Double vlrTotIcmsSt = 0.0;
    private Double vlrTotIcmsStNaoAprop = 0.0;
    private List<ItemCiapDepreciacaoBaixaBem> itemCiapDepreciacaoBaixaBem = new ArrayList<ItemCiapDepreciacaoBaixaBem>();
    private Short recalcularCiap = 0;
    private Short recalcularDepreciacao = 0;
    private Short gerarMovimentoBaixaBemDepreciadoTotal = 1;

    @Id
    @Column(name="ID_DEPR_CIAP")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_DEPR_CIAP")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="PERIODO")
    public Date getPeriodo() {
        return this.periodo;
    }

    public void setPeriodo(Date periodo) {
        this.periodo = periodo;
    }

    @Column(name="NUMERO_TURNOS")
    public Short getNumeroTurnos() {
        return this.numeroTurnos;
    }

    public void setNumeroTurnos(Short numeroTurnos) {
        this.numeroTurnos = numeroTurnos;
    }

    @Column(name="GERAR_CIAP")
    public Short getGerarCiap() {
        return this.gerarCiap;
    }

    public void setGerarCiap(Short gerarCiap) {
        this.gerarCiap = gerarCiap;
    }

    @Column(name="GERAR_DEPRECIACAO")
    public Short getGerarDepreciacao() {
        return this.gerarDepreciacao;
    }

    public void setGerarDepreciacao(Short gerarDepreciacao) {
        this.gerarDepreciacao = gerarDepreciacao;
    }

    @Column(name="VALOR_TRIB_EXPORTACAO", precision=15, scale=2)
    public Double getValorTribExportacao() {
        return this.valorTribExportacao;
    }

    public void setValorTribExportacao(Double valorTribExportacao) {
        this.valorTribExportacao = valorTribExportacao;
    }

    @Column(name="TOTAL_SAIDAS", precision=15, scale=2)
    public Double getTotalSaidas() {
        return this.totalSaidas;
    }

    public void setTotalSaidas(Double totalSaidas) {
        this.totalSaidas = totalSaidas;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_DEPRECIACAO_CIAP_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="VLR_TOT_ICMS", precision=15, scale=2)
    public Double getVlrTotIcms() {
        return this.vlrTotIcms;
    }

    public void setVlrTotIcms(Double vlrTotIcms) {
        this.vlrTotIcms = vlrTotIcms;
    }

    @Column(name="VLR_TOT_ICMS_NAO_APROP", precision=15, scale=2)
    public Double getVlrTotIcmsNaoAprop() {
        return this.vlrTotIcmsNaoAprop;
    }

    public void setVlrTotIcmsNaoAprop(Double vlrTotIcmsNaoAprop) {
        this.vlrTotIcmsNaoAprop = vlrTotIcmsNaoAprop;
    }

    @Column(nullable=false, name="VLR_TOT_DEPR", precision=15, scale=2)
    public Double getVlrTotDepr() {
        return this.vlrTotDepr;
    }

    public void setVlrTotDepr(Double vlrTotDepr) {
        this.vlrTotDepr = vlrTotDepr;
    }

    @Column(name="VLR_TOT_DEPR_ACEL", precision=15, scale=2)
    public Double getVlrTotDeprAcel() {
        return this.vlrTotDeprAcel;
    }

    public void setVlrTotDeprAcel(Double vlrTotDeprAcel) {
        this.vlrTotDeprAcel = vlrTotDeprAcel;
    }

    @Column(name="VLR_TOT_ICMS_FRETE", precision=15, scale=2)
    public Double getVlrTotIcmsFrete() {
        return this.vlrTotIcmsFrete;
    }

    public void setVlrTotIcmsFrete(Double vlrTotIcmsFrete) {
        this.vlrTotIcmsFrete = vlrTotIcmsFrete;
    }

    @Column(name="VLR_TOT_ICMS_FRETE_N_APR", precision=15, scale=2)
    public Double getVlrTotIcmsFretNaoAprop() {
        return this.vlrTotIcmsFretNaoAprop;
    }

    public void setVlrTotIcmsFretNaoAprop(Double vlrTotIcmsFretNaoAprop) {
        this.vlrTotIcmsFretNaoAprop = vlrTotIcmsFretNaoAprop;
    }

    @Column(name="VLR_TOT_ICMS_DIF_ALIQ", precision=15, scale=2)
    public Double getVlrTotIcmsDifAliq() {
        return this.vlrTotIcmsDifAliq;
    }

    public void setVlrTotIcmsDifAliq(Double vlrTotIcmsDifAliq) {
        this.vlrTotIcmsDifAliq = vlrTotIcmsDifAliq;
    }

    @Column(name="VLR_TOT_ICMS_DIF_ALIQ_N_APR", precision=15, scale=2)
    public Double getVlrTotIcmsDifAliqNaoAprop() {
        return this.vlrTotIcmsDifAliqNaoAprop;
    }

    public void setVlrTotIcmsDifAliqNaoAprop(Double vlrTotIcmsDifAliqNaoAprop) {
        this.vlrTotIcmsDifAliqNaoAprop = vlrTotIcmsDifAliqNaoAprop;
    }

    @Column(nullable=false, name="VLR_TOT_ICMS_ST", precision=15, scale=2)
    public Double getVlrTotIcmsSt() {
        return this.vlrTotIcmsSt;
    }

    public void setVlrTotIcmsSt(Double vlrTotIcmsSt) {
        this.vlrTotIcmsSt = vlrTotIcmsSt;
    }

    @Column(nullable=false, name="VLR_TOT_ICMS_ST_NAO_APROP", precision=15, scale=2)
    public Double getVlrTotIcmsStNaoAprop() {
        return this.vlrTotIcmsStNaoAprop;
    }

    public void setVlrTotIcmsStNaoAprop(Double vlrTotIcmsStNaoAprop) {
        this.vlrTotIcmsStNaoAprop = vlrTotIcmsStNaoAprop;
    }

    @OneToMany(mappedBy="depreciacaoCiap")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ItemCiapDepreciacaoBaixaBem> getItemCiapDepreciacaoBaixaBem() {
        return this.itemCiapDepreciacaoBaixaBem;
    }

    public void setItemCiapDepreciacaoBaixaBem(List<ItemCiapDepreciacaoBaixaBem> itemCiapDepreciacaoBaixaBem) {
        this.itemCiapDepreciacaoBaixaBem = itemCiapDepreciacaoBaixaBem;
    }

    @Column(name="RECALCULAR_CIAP")
    public Short getRecalcularCiap() {
        return this.recalcularCiap;
    }

    public void setRecalcularCiap(Short recalcularCiap) {
        this.recalcularCiap = recalcularCiap;
    }

    @Column(name="RECALCULAR_DEPRECIACAO")
    public Short getRecalcularDepreciacao() {
        return this.recalcularDepreciacao;
    }

    public void setRecalcularDepreciacao(Short recalcularDepreciacao) {
        this.recalcularDepreciacao = recalcularDepreciacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getPeriodo()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="GERAR_MOV_BAIXA_BEM_DEP_TOTAL")
    public Short getGerarMovimentoBaixaBemDepreciadoTotal() {
        return this.gerarMovimentoBaixaBemDepreciadoTotal;
    }

    public void setGerarMovimentoBaixaBemDepreciadoTotal(Short gerarMovimentoBaixaBemDepreciadoTotal) {
        this.gerarMovimentoBaixaBemDepreciadoTotal = gerarMovimentoBaixaBemDepreciadoTotal;
    }
}

